package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.TableName
import scala.jdk.CollectionConverters._
final case class DescribeGlobalTableRequest(globalTableName: TableName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableRequest = {
    import DescribeGlobalTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableRequest
      .builder()
      .globalTableName(TableName.unwrap(globalTableName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.DescribeGlobalTableRequest.ReadOnly =
    zio.aws.dynamodb.model.DescribeGlobalTableRequest.wrap(buildAwsValue())
}
object DescribeGlobalTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DescribeGlobalTableRequest =
      zio.aws.dynamodb.model.DescribeGlobalTableRequest(globalTableName)
    def globalTableName: TableName
    def getGlobalTableName: ZIO[Any, Nothing, TableName] =
      ZIO.succeed(globalTableName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableRequest
  ) extends zio.aws.dynamodb.model.DescribeGlobalTableRequest.ReadOnly {
    override val globalTableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.globalTableName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableRequest
  ): zio.aws.dynamodb.model.DescribeGlobalTableRequest.ReadOnly = new Wrapper(
    impl
  )
}
