package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Endpoint(address: String, cachePeriodInMinutes: Long) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.Endpoint = {
    import Endpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.Endpoint
      .builder()
      .address(address: java.lang.String)
      .cachePeriodInMinutes(cachePeriodInMinutes: java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.Endpoint.ReadOnly =
    zio.aws.dynamodb.model.Endpoint.wrap(buildAwsValue())
}
object Endpoint {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dynamodb.model.Endpoint] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.Endpoint =
      zio.aws.dynamodb.model.Endpoint(address, cachePeriodInMinutes)
    def address: String
    def cachePeriodInMinutes: Long
    def getAddress: ZIO[Any, Nothing, String] = ZIO.succeed(address)
    def getCachePeriodInMinutes: ZIO[Any, Nothing, Long] =
      ZIO.succeed(cachePeriodInMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.Endpoint
  ) extends zio.aws.dynamodb.model.Endpoint.ReadOnly {
    override val address: String = impl.address(): String
    override val cachePeriodInMinutes: Long = impl.cachePeriodInMinutes(): Long
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.Endpoint
  ): zio.aws.dynamodb.model.Endpoint.ReadOnly = new Wrapper(impl)
}
