package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.IndexName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReplicaGlobalSecondaryIndexAutoScalingUpdate(
    indexName: Optional[IndexName] = Optional.Absent,
    provisionedReadCapacityAutoScalingUpdate: Optional[
      zio.aws.dynamodb.model.AutoScalingSettingsUpdate
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate = {
    import ReplicaGlobalSecondaryIndexAutoScalingUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate
      .builder()
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(
        provisionedReadCapacityAutoScalingUpdate.map(value =>
          value.buildAwsValue()
        )
      )(_.provisionedReadCapacityAutoScalingUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate.ReadOnly =
    zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate
      .wrap(buildAwsValue())
}
object ReplicaGlobalSecondaryIndexAutoScalingUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate =
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate(
        indexName.map(value => value),
        provisionedReadCapacityAutoScalingUpdate.map(value => value.asEditable)
      )
    def indexName: Optional[IndexName]
    def provisionedReadCapacityAutoScalingUpdate
        : Optional[zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly]
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getProvisionedReadCapacityAutoScalingUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedReadCapacityAutoScalingUpdate",
      provisionedReadCapacityAutoScalingUpdate
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate
  ) extends zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate.ReadOnly {
    override val indexName: Optional[IndexName] = zio.aws.core.internal
      .optionalFromNullable(impl.indexName())
      .map(value => zio.aws.dynamodb.model.primitives.IndexName(value))
    override val provisionedReadCapacityAutoScalingUpdate
        : Optional[zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedReadCapacityAutoScalingUpdate())
        .map(value =>
          zio.aws.dynamodb.model.AutoScalingSettingsUpdate.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate
  ): zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate.ReadOnly =
    new Wrapper(impl)
}
