package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.PositiveLongObject
import scala.jdk.CollectionConverters._
final case class ProvisionedThroughput(
    readCapacityUnits: PositiveLongObject,
    writeCapacityUnits: PositiveLongObject
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput = {
    import ProvisionedThroughput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput
      .builder()
      .readCapacityUnits(
        PositiveLongObject.unwrap(readCapacityUnits): java.lang.Long
      )
      .writeCapacityUnits(
        PositiveLongObject.unwrap(writeCapacityUnits): java.lang.Long
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly =
    zio.aws.dynamodb.model.ProvisionedThroughput.wrap(buildAwsValue())
}
object ProvisionedThroughput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ProvisionedThroughput =
      zio.aws.dynamodb.model
        .ProvisionedThroughput(readCapacityUnits, writeCapacityUnits)
    def readCapacityUnits: PositiveLongObject
    def writeCapacityUnits: PositiveLongObject
    def getReadCapacityUnits: ZIO[Any, Nothing, PositiveLongObject] =
      ZIO.succeed(readCapacityUnits)
    def getWriteCapacityUnits: ZIO[Any, Nothing, PositiveLongObject] =
      ZIO.succeed(writeCapacityUnits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput
  ) extends zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly {
    override val readCapacityUnits: PositiveLongObject =
      zio.aws.dynamodb.model.primitives
        .PositiveLongObject(impl.readCapacityUnits())
    override val writeCapacityUnits: PositiveLongObject =
      zio.aws.dynamodb.model.primitives
        .PositiveLongObject(impl.writeCapacityUnits())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput
  ): zio.aws.dynamodb.model.ProvisionedThroughput.ReadOnly = new Wrapper(impl)
}
