package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.AttributeName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ItemResponse(
    item: Optional[Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ItemResponse = {
    import ItemResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ItemResponse
      .builder()
      .optionallyWith(
        item.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.item)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ItemResponse.ReadOnly =
    zio.aws.dynamodb.model.ItemResponse.wrap(buildAwsValue())
}
object ItemResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ItemResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ItemResponse =
      zio.aws.dynamodb.model.ItemResponse(
        item.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def item: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ]
    def getItem: ZIO[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("item", item)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ItemResponse
  ) extends zio.aws.dynamodb.model.ItemResponse.ReadOnly {
    override val item: Optional[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.item())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ItemResponse
  ): zio.aws.dynamodb.model.ItemResponse.ReadOnly = new Wrapper(impl)
}
