package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.{TagValueString, TagKeyString}
import scala.jdk.CollectionConverters._
final case class Tag(key: TagKeyString, value: TagValueString) {
  def buildAwsValue(): software.amazon.awssdk.services.dynamodb.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.Tag
      .builder()
      .key(TagKeyString.unwrap(key): java.lang.String)
      .value(TagValueString.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.Tag.ReadOnly =
    zio.aws.dynamodb.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dynamodb.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.Tag =
      zio.aws.dynamodb.model.Tag(key, value)
    def key: TagKeyString
    def value: TagValueString
    def getKey: ZIO[Any, Nothing, TagKeyString] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, TagValueString] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.Tag
  ) extends zio.aws.dynamodb.model.Tag.ReadOnly {
    override val key: TagKeyString =
      zio.aws.dynamodb.model.primitives.TagKeyString(impl.key())
    override val value: TagValueString =
      zio.aws.dynamodb.model.primitives.TagValueString(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.Tag
  ): zio.aws.dynamodb.model.Tag.ReadOnly = new Wrapper(impl)
}
