package zio.aws.dynamodb.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.dynamodb.model.primitives.{
  NonNegativeLongObject,
  PositiveLongObject,
  Date
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ProvisionedThroughputDescription(
    lastIncreaseDateTime: Optional[Date] = Optional.Absent,
    lastDecreaseDateTime: Optional[Date] = Optional.Absent,
    numberOfDecreasesToday: Optional[PositiveLongObject] = Optional.Absent,
    readCapacityUnits: Optional[NonNegativeLongObject] = Optional.Absent,
    writeCapacityUnits: Optional[NonNegativeLongObject] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputDescription = {
    import ProvisionedThroughputDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputDescription
      .builder()
      .optionallyWith(
        lastIncreaseDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastIncreaseDateTime)
      .optionallyWith(
        lastDecreaseDateTime.map(value => Date.unwrap(value): Instant)
      )(_.lastDecreaseDateTime)
      .optionallyWith(
        numberOfDecreasesToday.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.numberOfDecreasesToday)
      .optionallyWith(
        readCapacityUnits.map(value =>
          NonNegativeLongObject.unwrap(value): java.lang.Long
        )
      )(_.readCapacityUnits)
      .optionallyWith(
        writeCapacityUnits.map(value =>
          NonNegativeLongObject.unwrap(value): java.lang.Long
        )
      )(_.writeCapacityUnits)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.ProvisionedThroughputDescription.ReadOnly =
    zio.aws.dynamodb.model.ProvisionedThroughputDescription
      .wrap(buildAwsValue())
}
object ProvisionedThroughputDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ProvisionedThroughputDescription =
      zio.aws.dynamodb.model.ProvisionedThroughputDescription(
        lastIncreaseDateTime.map(value => value),
        lastDecreaseDateTime.map(value => value),
        numberOfDecreasesToday.map(value => value),
        readCapacityUnits.map(value => value),
        writeCapacityUnits.map(value => value)
      )
    def lastIncreaseDateTime: Optional[Date]
    def lastDecreaseDateTime: Optional[Date]
    def numberOfDecreasesToday: Optional[PositiveLongObject]
    def readCapacityUnits: Optional[NonNegativeLongObject]
    def writeCapacityUnits: Optional[NonNegativeLongObject]
    def getLastIncreaseDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastIncreaseDateTime", lastIncreaseDateTime)
    def getLastDecreaseDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastDecreaseDateTime", lastDecreaseDateTime)
    def getNumberOfDecreasesToday: ZIO[Any, AwsError, PositiveLongObject] =
      AwsError.unwrapOptionField(
        "numberOfDecreasesToday",
        numberOfDecreasesToday
      )
    def getReadCapacityUnits: ZIO[Any, AwsError, NonNegativeLongObject] =
      AwsError.unwrapOptionField("readCapacityUnits", readCapacityUnits)
    def getWriteCapacityUnits: ZIO[Any, AwsError, NonNegativeLongObject] =
      AwsError.unwrapOptionField("writeCapacityUnits", writeCapacityUnits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputDescription
  ) extends zio.aws.dynamodb.model.ProvisionedThroughputDescription.ReadOnly {
    override val lastIncreaseDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastIncreaseDateTime())
      .map(value => zio.aws.dynamodb.model.primitives.Date(value))
    override val lastDecreaseDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastDecreaseDateTime())
      .map(value => zio.aws.dynamodb.model.primitives.Date(value))
    override val numberOfDecreasesToday: Optional[PositiveLongObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfDecreasesToday())
        .map(value =>
          zio.aws.dynamodb.model.primitives.PositiveLongObject(value)
        )
    override val readCapacityUnits: Optional[NonNegativeLongObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readCapacityUnits())
        .map(value =>
          zio.aws.dynamodb.model.primitives.NonNegativeLongObject(value)
        )
    override val writeCapacityUnits: Optional[NonNegativeLongObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.writeCapacityUnits())
        .map(value =>
          zio.aws.dynamodb.model.primitives.NonNegativeLongObject(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputDescription
  ): zio.aws.dynamodb.model.ProvisionedThroughputDescription.ReadOnly =
    new Wrapper(impl)
}
