package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TransactWriteItem(
    conditionCheck: Option[zio.aws.dynamodb.model.ConditionCheck] = None,
    put: Option[zio.aws.dynamodb.model.Put] = None,
    delete: Option[zio.aws.dynamodb.model.Delete] = None,
    update: Option[zio.aws.dynamodb.model.Update] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.TransactWriteItem = {
    import TransactWriteItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.TransactWriteItem
      .builder()
      .optionallyWith(conditionCheck.map(value => value.buildAwsValue()))(
        _.conditionCheck
      )
      .optionallyWith(put.map(value => value.buildAwsValue()))(_.put)
      .optionallyWith(delete.map(value => value.buildAwsValue()))(_.delete)
      .optionallyWith(update.map(value => value.buildAwsValue()))(_.update)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.TransactWriteItem.ReadOnly =
    zio.aws.dynamodb.model.TransactWriteItem.wrap(buildAwsValue())
}
object TransactWriteItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.TransactWriteItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.TransactWriteItem =
      zio.aws.dynamodb.model.TransactWriteItem(
        conditionCheck.map(value => value.asEditable),
        put.map(value => value.asEditable),
        delete.map(value => value.asEditable),
        update.map(value => value.asEditable)
      )
    def conditionCheck: Option[zio.aws.dynamodb.model.ConditionCheck.ReadOnly]
    def put: Option[zio.aws.dynamodb.model.Put.ReadOnly]
    def delete: Option[zio.aws.dynamodb.model.Delete.ReadOnly]
    def update: Option[zio.aws.dynamodb.model.Update.ReadOnly]
    def getConditionCheck
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ConditionCheck.ReadOnly] =
      AwsError.unwrapOptionField("conditionCheck", conditionCheck)
    def getPut: ZIO[Any, AwsError, zio.aws.dynamodb.model.Put.ReadOnly] =
      AwsError.unwrapOptionField("put", put)
    def getDelete: ZIO[Any, AwsError, zio.aws.dynamodb.model.Delete.ReadOnly] =
      AwsError.unwrapOptionField("delete", delete)
    def getUpdate: ZIO[Any, AwsError, zio.aws.dynamodb.model.Update.ReadOnly] =
      AwsError.unwrapOptionField("update", update)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.TransactWriteItem
  ) extends zio.aws.dynamodb.model.TransactWriteItem.ReadOnly {
    override val conditionCheck
        : Option[zio.aws.dynamodb.model.ConditionCheck.ReadOnly] = scala
      .Option(impl.conditionCheck())
      .map(value => zio.aws.dynamodb.model.ConditionCheck.wrap(value))
    override val put: Option[zio.aws.dynamodb.model.Put.ReadOnly] = scala
      .Option(impl.put())
      .map(value => zio.aws.dynamodb.model.Put.wrap(value))
    override val delete: Option[zio.aws.dynamodb.model.Delete.ReadOnly] = scala
      .Option(impl.delete())
      .map(value => zio.aws.dynamodb.model.Delete.wrap(value))
    override val update: Option[zio.aws.dynamodb.model.Update.ReadOnly] = scala
      .Option(impl.update())
      .map(value => zio.aws.dynamodb.model.Update.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.TransactWriteItem
  ): zio.aws.dynamodb.model.TransactWriteItem.ReadOnly = new Wrapper(impl)
}
