package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.IndexName
import scala.jdk.CollectionConverters._
final case class ReplicaGlobalSecondaryIndexAutoScalingUpdate(
    indexName: Option[IndexName] = None,
    provisionedReadCapacityAutoScalingUpdate: Option[
      zio.aws.dynamodb.model.AutoScalingSettingsUpdate
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate = {
    import ReplicaGlobalSecondaryIndexAutoScalingUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate
      .builder()
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(
        provisionedReadCapacityAutoScalingUpdate.map(value =>
          value.buildAwsValue()
        )
      )(_.provisionedReadCapacityAutoScalingUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate.ReadOnly =
    zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate
      .wrap(buildAwsValue())
}
object ReplicaGlobalSecondaryIndexAutoScalingUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate =
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate(
        indexName.map(value => value),
        provisionedReadCapacityAutoScalingUpdate.map(value => value.asEditable)
      )
    def indexName: Option[IndexName]
    def provisionedReadCapacityAutoScalingUpdate
        : Option[zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly]
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getProvisionedReadCapacityAutoScalingUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedReadCapacityAutoScalingUpdate",
      provisionedReadCapacityAutoScalingUpdate
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate
  ) extends zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate.ReadOnly {
    override val indexName: Option[IndexName] = scala
      .Option(impl.indexName())
      .map(value => zio.aws.dynamodb.model.primitives.IndexName(value))
    override val provisionedReadCapacityAutoScalingUpdate
        : Option[zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly] =
      scala
        .Option(impl.provisionedReadCapacityAutoScalingUpdate())
        .map(value =>
          zio.aws.dynamodb.model.AutoScalingSettingsUpdate.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate
  ): zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate.ReadOnly =
    new Wrapper(impl)
}
