package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  Date,
  KMSMasterKeyId,
  RegionName,
  ReplicaStatusPercentProgress,
  ReplicaStatusDescription
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ReplicaDescription(
    regionName: Option[RegionName] = None,
    replicaStatus: Option[zio.aws.dynamodb.model.ReplicaStatus] = None,
    replicaStatusDescription: Option[ReplicaStatusDescription] = None,
    replicaStatusPercentProgress: Option[ReplicaStatusPercentProgress] = None,
    kmsMasterKeyId: Option[KMSMasterKeyId] = None,
    provisionedThroughputOverride: Option[
      zio.aws.dynamodb.model.ProvisionedThroughputOverride
    ] = None,
    globalSecondaryIndexes: Option[
      Iterable[zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexDescription]
    ] = None,
    replicaInaccessibleDateTime: Option[Date] = None,
    replicaTableClassSummary: Option[zio.aws.dynamodb.model.TableClassSummary] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ReplicaDescription = {
    import ReplicaDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ReplicaDescription
      .builder()
      .optionallyWith(
        regionName.map(value => RegionName.unwrap(value): java.lang.String)
      )(_.regionName)
      .optionallyWith(replicaStatus.map(value => value.unwrap))(_.replicaStatus)
      .optionallyWith(
        replicaStatusDescription.map(value =>
          ReplicaStatusDescription.unwrap(value): java.lang.String
        )
      )(_.replicaStatusDescription)
      .optionallyWith(
        replicaStatusPercentProgress.map(value =>
          ReplicaStatusPercentProgress.unwrap(value): java.lang.String
        )
      )(_.replicaStatusPercentProgress)
      .optionallyWith(
        kmsMasterKeyId.map(value =>
          KMSMasterKeyId.unwrap(value): java.lang.String
        )
      )(_.kmsMasterKeyId)
      .optionallyWith(
        provisionedThroughputOverride.map(value => value.buildAwsValue())
      )(_.provisionedThroughputOverride)
      .optionallyWith(
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalSecondaryIndexes)
      .optionallyWith(
        replicaInaccessibleDateTime.map(value => Date.unwrap(value): Instant)
      )(_.replicaInaccessibleDateTime)
      .optionallyWith(
        replicaTableClassSummary.map(value => value.buildAwsValue())
      )(_.replicaTableClassSummary)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ReplicaDescription.ReadOnly =
    zio.aws.dynamodb.model.ReplicaDescription.wrap(buildAwsValue())
}
object ReplicaDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ReplicaDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ReplicaDescription =
      zio.aws.dynamodb.model.ReplicaDescription(
        regionName.map(value => value),
        replicaStatus.map(value => value),
        replicaStatusDescription.map(value => value),
        replicaStatusPercentProgress.map(value => value),
        kmsMasterKeyId.map(value => value),
        provisionedThroughputOverride.map(value => value.asEditable),
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        replicaInaccessibleDateTime.map(value => value),
        replicaTableClassSummary.map(value => value.asEditable)
      )
    def regionName: Option[RegionName]
    def replicaStatus: Option[zio.aws.dynamodb.model.ReplicaStatus]
    def replicaStatusDescription: Option[ReplicaStatusDescription]
    def replicaStatusPercentProgress: Option[ReplicaStatusPercentProgress]
    def kmsMasterKeyId: Option[KMSMasterKeyId]
    def provisionedThroughputOverride
        : Option[zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly]
    def globalSecondaryIndexes: Option[List[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexDescription.ReadOnly
    ]]
    def replicaInaccessibleDateTime: Option[Date]
    def replicaTableClassSummary
        : Option[zio.aws.dynamodb.model.TableClassSummary.ReadOnly]
    def getRegionName: ZIO[Any, AwsError, RegionName] =
      AwsError.unwrapOptionField("regionName", regionName)
    def getReplicaStatus
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ReplicaStatus] =
      AwsError.unwrapOptionField("replicaStatus", replicaStatus)
    def getReplicaStatusDescription
        : ZIO[Any, AwsError, ReplicaStatusDescription] = AwsError
      .unwrapOptionField("replicaStatusDescription", replicaStatusDescription)
    def getReplicaStatusPercentProgress
        : ZIO[Any, AwsError, ReplicaStatusPercentProgress] =
      AwsError.unwrapOptionField(
        "replicaStatusPercentProgress",
        replicaStatusPercentProgress
      )
    def getKmsMasterKeyId: ZIO[Any, AwsError, KMSMasterKeyId] =
      AwsError.unwrapOptionField("kmsMasterKeyId", kmsMasterKeyId)
    def getProvisionedThroughputOverride: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedThroughputOverride",
      provisionedThroughputOverride
    )
    def getGlobalSecondaryIndexes: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "globalSecondaryIndexes",
      globalSecondaryIndexes
    )
    def getReplicaInaccessibleDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField(
        "replicaInaccessibleDateTime",
        replicaInaccessibleDateTime
      )
    def getReplicaTableClassSummary: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.TableClassSummary.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicaTableClassSummary",
      replicaTableClassSummary
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaDescription
  ) extends zio.aws.dynamodb.model.ReplicaDescription.ReadOnly {
    override val regionName: Option[RegionName] = scala
      .Option(impl.regionName())
      .map(value => zio.aws.dynamodb.model.primitives.RegionName(value))
    override val replicaStatus: Option[zio.aws.dynamodb.model.ReplicaStatus] =
      scala
        .Option(impl.replicaStatus())
        .map(value => zio.aws.dynamodb.model.ReplicaStatus.wrap(value))
    override val replicaStatusDescription: Option[ReplicaStatusDescription] =
      scala
        .Option(impl.replicaStatusDescription())
        .map(value =>
          zio.aws.dynamodb.model.primitives.ReplicaStatusDescription(value)
        )
    override val replicaStatusPercentProgress
        : Option[ReplicaStatusPercentProgress] = scala
      .Option(impl.replicaStatusPercentProgress())
      .map(value =>
        zio.aws.dynamodb.model.primitives.ReplicaStatusPercentProgress(value)
      )
    override val kmsMasterKeyId: Option[KMSMasterKeyId] = scala
      .Option(impl.kmsMasterKeyId())
      .map(value => zio.aws.dynamodb.model.primitives.KMSMasterKeyId(value))
    override val provisionedThroughputOverride: Option[
      zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly
    ] = scala
      .Option(impl.provisionedThroughputOverride())
      .map(value =>
        zio.aws.dynamodb.model.ProvisionedThroughputOverride.wrap(value)
      )
    override val globalSecondaryIndexes: Option[List[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexDescription.ReadOnly
    ]] = scala
      .Option(impl.globalSecondaryIndexes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexDescription
            .wrap(item)
        }.toList
      )
    override val replicaInaccessibleDateTime: Option[Date] = scala
      .Option(impl.replicaInaccessibleDateTime())
      .map(value => zio.aws.dynamodb.model.primitives.Date(value))
    override val replicaTableClassSummary
        : Option[zio.aws.dynamodb.model.TableClassSummary.ReadOnly] = scala
      .Option(impl.replicaTableClassSummary())
      .map(value => zio.aws.dynamodb.model.TableClassSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaDescription
  ): zio.aws.dynamodb.model.ReplicaDescription.ReadOnly = new Wrapper(impl)
}
