package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.TableName
import scala.jdk.CollectionConverters._
final case class TransactWriteItemsResponse(
    consumedCapacity: Option[
      Iterable[zio.aws.dynamodb.model.ConsumedCapacity]
    ] = None,
    itemCollectionMetrics: Option[
      Map[TableName, Iterable[zio.aws.dynamodb.model.ItemCollectionMetrics]]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsResponse = {
    import TransactWriteItemsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsResponse
      .builder()
      .optionallyWith(
        consumedCapacity.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.consumedCapacity)
      .optionallyWith(
        itemCollectionMetrics.map(value =>
          value
            .map({ case (key, value) =>
              (TableName.unwrap(key): java.lang.String) -> value.map { item =>
                item.buildAwsValue()
              }.asJavaCollection
            })
            .asJava
        )
      )(_.itemCollectionMetrics)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.TransactWriteItemsResponse.ReadOnly =
    zio.aws.dynamodb.model.TransactWriteItemsResponse.wrap(buildAwsValue())
}
object TransactWriteItemsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.TransactWriteItemsResponse =
      zio.aws.dynamodb.model.TransactWriteItemsResponse(
        consumedCapacity.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        itemCollectionMetrics.map(value =>
          value.map({ case (key, value) =>
            key -> value.map { item =>
              item.asEditable
            }
          })
        )
      )
    def consumedCapacity
        : Option[List[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly]]
    def itemCollectionMetrics: Option[Map[TableName, List[
      zio.aws.dynamodb.model.ItemCollectionMetrics.ReadOnly
    ]]]
    def getConsumedCapacity: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly
    ]] = AwsError.unwrapOptionField("consumedCapacity", consumedCapacity)
    def getItemCollectionMetrics: ZIO[Any, AwsError, Map[TableName, List[
      zio.aws.dynamodb.model.ItemCollectionMetrics.ReadOnly
    ]]] =
      AwsError.unwrapOptionField("itemCollectionMetrics", itemCollectionMetrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsResponse
  ) extends zio.aws.dynamodb.model.TransactWriteItemsResponse.ReadOnly {
    override val consumedCapacity
        : Option[List[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly]] = scala
      .Option(impl.consumedCapacity())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.ConsumedCapacity.wrap(item)
        }.toList
      )
    override val itemCollectionMetrics: Option[Map[TableName, List[
      zio.aws.dynamodb.model.ItemCollectionMetrics.ReadOnly
    ]]] = scala
      .Option(impl.itemCollectionMetrics())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives
              .TableName(key) -> value.asScala.map { item =>
              zio.aws.dynamodb.model.ItemCollectionMetrics.wrap(item)
            }.toList
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsResponse
  ): zio.aws.dynamodb.model.TransactWriteItemsResponse.ReadOnly = new Wrapper(
    impl
  )
}
