package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RestoreTableToPointInTimeResponse(
    tableDescription: Option[zio.aws.dynamodb.model.TableDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeResponse = {
    import RestoreTableToPointInTimeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeResponse
      .builder()
      .optionallyWith(tableDescription.map(value => value.buildAwsValue()))(
        _.tableDescription
      )
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.RestoreTableToPointInTimeResponse.ReadOnly =
    zio.aws.dynamodb.model.RestoreTableToPointInTimeResponse
      .wrap(buildAwsValue())
}
object RestoreTableToPointInTimeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.RestoreTableToPointInTimeResponse =
      zio.aws.dynamodb.model.RestoreTableToPointInTimeResponse(
        tableDescription.map(value => value.asEditable)
      )
    def tableDescription
        : Option[zio.aws.dynamodb.model.TableDescription.ReadOnly]
    def getTableDescription
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.TableDescription.ReadOnly] =
      AwsError.unwrapOptionField("tableDescription", tableDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeResponse
  ) extends zio.aws.dynamodb.model.RestoreTableToPointInTimeResponse.ReadOnly {
    override val tableDescription
        : Option[zio.aws.dynamodb.model.TableDescription.ReadOnly] = scala
      .Option(impl.tableDescription())
      .map(value => zio.aws.dynamodb.model.TableDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeResponse
  ): zio.aws.dynamodb.model.RestoreTableToPointInTimeResponse.ReadOnly =
    new Wrapper(impl)
}
