package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.NonKeyAttributeName
import scala.jdk.CollectionConverters._
final case class Projection(
    projectionType: Option[zio.aws.dynamodb.model.ProjectionType] = None,
    nonKeyAttributes: Option[Iterable[NonKeyAttributeName]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.Projection = {
    import Projection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.Projection
      .builder()
      .optionallyWith(projectionType.map(value => value.unwrap))(
        _.projectionType
      )
      .optionallyWith(
        nonKeyAttributes.map(value =>
          value.map { item =>
            NonKeyAttributeName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.nonKeyAttributes)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.Projection.ReadOnly =
    zio.aws.dynamodb.model.Projection.wrap(buildAwsValue())
}
object Projection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.Projection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.Projection =
      zio.aws.dynamodb.model.Projection(
        projectionType.map(value => value),
        nonKeyAttributes.map(value => value)
      )
    def projectionType: Option[zio.aws.dynamodb.model.ProjectionType]
    def nonKeyAttributes: Option[List[NonKeyAttributeName]]
    def getProjectionType
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ProjectionType] =
      AwsError.unwrapOptionField("projectionType", projectionType)
    def getNonKeyAttributes: ZIO[Any, AwsError, List[NonKeyAttributeName]] =
      AwsError.unwrapOptionField("nonKeyAttributes", nonKeyAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.Projection
  ) extends zio.aws.dynamodb.model.Projection.ReadOnly {
    override val projectionType: Option[zio.aws.dynamodb.model.ProjectionType] =
      scala
        .Option(impl.projectionType())
        .map(value => zio.aws.dynamodb.model.ProjectionType.wrap(value))
    override val nonKeyAttributes: Option[List[NonKeyAttributeName]] = scala
      .Option(impl.nonKeyAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.primitives.NonKeyAttributeName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.Projection
  ): zio.aws.dynamodb.model.Projection.ReadOnly = new Wrapper(impl)
}
