package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.TableName
import scala.jdk.CollectionConverters._
final case class BatchGetItemRequest(
    requestItems: Map[TableName, zio.aws.dynamodb.model.KeysAndAttributes],
    returnConsumedCapacity: Option[
      zio.aws.dynamodb.model.ReturnConsumedCapacity
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest = {
    import BatchGetItemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest
      .builder()
      .requestItems(
        requestItems
          .map({ case (key, value) =>
            (TableName.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .optionallyWith(returnConsumedCapacity.map(value => value.unwrap))(
        _.returnConsumedCapacity
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.BatchGetItemRequest.ReadOnly =
    zio.aws.dynamodb.model.BatchGetItemRequest.wrap(buildAwsValue())
}
object BatchGetItemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.BatchGetItemRequest =
      zio.aws.dynamodb.model.BatchGetItemRequest(
        requestItems.map({ case (key, value) =>
          key -> value.asEditable
        }),
        returnConsumedCapacity.map(value => value)
      )
    def requestItems
        : Map[TableName, zio.aws.dynamodb.model.KeysAndAttributes.ReadOnly]
    def returnConsumedCapacity
        : Option[zio.aws.dynamodb.model.ReturnConsumedCapacity]
    def getRequestItems: ZIO[Any, Nothing, Map[
      TableName,
      zio.aws.dynamodb.model.KeysAndAttributes.ReadOnly
    ]] = ZIO.succeed(requestItems)
    def getReturnConsumedCapacity
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ReturnConsumedCapacity] =
      AwsError.unwrapOptionField(
        "returnConsumedCapacity",
        returnConsumedCapacity
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest
  ) extends zio.aws.dynamodb.model.BatchGetItemRequest.ReadOnly {
    override val requestItems
        : Map[TableName, zio.aws.dynamodb.model.KeysAndAttributes.ReadOnly] =
      impl
        .requestItems()
        .asScala
        .map({ case (key, value) =>
          zio.aws.dynamodb.model.primitives.TableName(
            key
          ) -> zio.aws.dynamodb.model.KeysAndAttributes.wrap(value)
        })
        .toMap
    override val returnConsumedCapacity
        : Option[zio.aws.dynamodb.model.ReturnConsumedCapacity] = scala
      .Option(impl.returnConsumedCapacity())
      .map(value => zio.aws.dynamodb.model.ReturnConsumedCapacity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest
  ): zio.aws.dynamodb.model.BatchGetItemRequest.ReadOnly = new Wrapper(impl)
}
