package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AttributeValueUpdate(
    value: Option[zio.aws.dynamodb.model.AttributeValue] = None,
    action: Option[zio.aws.dynamodb.model.AttributeAction] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate = {
    import AttributeValueUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate
      .builder()
      .optionallyWith(value.map(value => value.buildAwsValue()))(_.value)
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.AttributeValueUpdate.ReadOnly =
    zio.aws.dynamodb.model.AttributeValueUpdate.wrap(buildAwsValue())
}
object AttributeValueUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.AttributeValueUpdate =
      zio.aws.dynamodb.model.AttributeValueUpdate(
        value.map(value => value.asEditable),
        action.map(value => value)
      )
    def value: Option[zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    def action: Option[zio.aws.dynamodb.model.AttributeAction]
    def getValue
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("value", value)
    def getAction: ZIO[Any, AwsError, zio.aws.dynamodb.model.AttributeAction] =
      AwsError.unwrapOptionField("action", action)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate
  ) extends zio.aws.dynamodb.model.AttributeValueUpdate.ReadOnly {
    override val value: Option[zio.aws.dynamodb.model.AttributeValue.ReadOnly] =
      scala
        .Option(impl.value())
        .map(value => zio.aws.dynamodb.model.AttributeValue.wrap(value))
    override val action: Option[zio.aws.dynamodb.model.AttributeAction] = scala
      .Option(impl.action())
      .map(value => zio.aws.dynamodb.model.AttributeAction.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate
  ): zio.aws.dynamodb.model.AttributeValueUpdate.ReadOnly = new Wrapper(impl)
}
