package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.IndexName
import scala.jdk.CollectionConverters._
final case class LocalSecondaryIndexDescription(
    indexName: Option[IndexName] = None,
    keySchema: Option[Iterable[zio.aws.dynamodb.model.KeySchemaElement]] = None,
    projection: Option[zio.aws.dynamodb.model.Projection] = None,
    indexSizeBytes: Option[Long] = None,
    itemCount: Option[Long] = None,
    indexArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexDescription = {
    import LocalSecondaryIndexDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexDescription
      .builder()
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(
        keySchema.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keySchema)
      .optionallyWith(projection.map(value => value.buildAwsValue()))(
        _.projection
      )
      .optionallyWith(indexSizeBytes.map(value => value: java.lang.Long))(
        _.indexSizeBytes
      )
      .optionallyWith(itemCount.map(value => value: java.lang.Long))(
        _.itemCount
      )
      .optionallyWith(indexArn.map(value => value: java.lang.String))(
        _.indexArn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.LocalSecondaryIndexDescription.ReadOnly =
    zio.aws.dynamodb.model.LocalSecondaryIndexDescription.wrap(buildAwsValue())
}
object LocalSecondaryIndexDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.LocalSecondaryIndexDescription =
      zio.aws.dynamodb.model.LocalSecondaryIndexDescription(
        indexName.map(value => value),
        keySchema.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        projection.map(value => value.asEditable),
        indexSizeBytes.map(value => value),
        itemCount.map(value => value),
        indexArn.map(value => value)
      )
    def indexName: Option[IndexName]
    def keySchema
        : Option[List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly]]
    def projection: Option[zio.aws.dynamodb.model.Projection.ReadOnly]
    def indexSizeBytes: Option[Long]
    def itemCount: Option[Long]
    def indexArn: Option[String]
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getKeySchema: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.KeySchemaElement.ReadOnly
    ]] = AwsError.unwrapOptionField("keySchema", keySchema)
    def getProjection
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.Projection.ReadOnly] =
      AwsError.unwrapOptionField("projection", projection)
    def getIndexSizeBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("indexSizeBytes", indexSizeBytes)
    def getItemCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("itemCount", itemCount)
    def getIndexArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("indexArn", indexArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexDescription
  ) extends zio.aws.dynamodb.model.LocalSecondaryIndexDescription.ReadOnly {
    override val indexName: Option[IndexName] = scala
      .Option(impl.indexName())
      .map(value => zio.aws.dynamodb.model.primitives.IndexName(value))
    override val keySchema
        : Option[List[zio.aws.dynamodb.model.KeySchemaElement.ReadOnly]] = scala
      .Option(impl.keySchema())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.KeySchemaElement.wrap(item)
        }.toList
      )
    override val projection
        : Option[zio.aws.dynamodb.model.Projection.ReadOnly] = scala
      .Option(impl.projection())
      .map(value => zio.aws.dynamodb.model.Projection.wrap(value))
    override val indexSizeBytes: Option[Long] =
      scala.Option(impl.indexSizeBytes()).map(value => value: Long)
    override val itemCount: Option[Long] =
      scala.Option(impl.itemCount()).map(value => value: Long)
    override val indexArn: Option[String] =
      scala.Option(impl.indexArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexDescription
  ): zio.aws.dynamodb.model.LocalSecondaryIndexDescription.ReadOnly =
    new Wrapper(impl)
}
