package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{ExceptionDescription, ExceptionName}
import scala.jdk.CollectionConverters._
final case class FailureException(
    exceptionName: Option[ExceptionName] = None,
    exceptionDescription: Option[ExceptionDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.FailureException = {
    import FailureException.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.FailureException
      .builder()
      .optionallyWith(
        exceptionName.map(value =>
          ExceptionName.unwrap(value): java.lang.String
        )
      )(_.exceptionName)
      .optionallyWith(
        exceptionDescription.map(value =>
          ExceptionDescription.unwrap(value): java.lang.String
        )
      )(_.exceptionDescription)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.FailureException.ReadOnly =
    zio.aws.dynamodb.model.FailureException.wrap(buildAwsValue())
}
object FailureException {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.FailureException
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.FailureException =
      zio.aws.dynamodb.model.FailureException(
        exceptionName.map(value => value),
        exceptionDescription.map(value => value)
      )
    def exceptionName: Option[ExceptionName]
    def exceptionDescription: Option[ExceptionDescription]
    def getExceptionName: ZIO[Any, AwsError, ExceptionName] =
      AwsError.unwrapOptionField("exceptionName", exceptionName)
    def getExceptionDescription: ZIO[Any, AwsError, ExceptionDescription] =
      AwsError.unwrapOptionField("exceptionDescription", exceptionDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.FailureException
  ) extends zio.aws.dynamodb.model.FailureException.ReadOnly {
    override val exceptionName: Option[ExceptionName] = scala
      .Option(impl.exceptionName())
      .map(value => zio.aws.dynamodb.model.primitives.ExceptionName(value))
    override val exceptionDescription: Option[ExceptionDescription] = scala
      .Option(impl.exceptionDescription())
      .map(value =>
        zio.aws.dynamodb.model.primitives.ExceptionDescription(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.FailureException
  ): zio.aws.dynamodb.model.FailureException.ReadOnly = new Wrapper(impl)
}
