package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{PositiveLongObject, TableName}
import scala.jdk.CollectionConverters._
final case class UpdateGlobalTableSettingsRequest(
    globalTableName: TableName,
    globalTableBillingMode: Option[zio.aws.dynamodb.model.BillingMode] = None,
    globalTableProvisionedWriteCapacityUnits: Option[PositiveLongObject] = None,
    globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate: Option[
      zio.aws.dynamodb.model.AutoScalingSettingsUpdate
    ] = None,
    globalTableGlobalSecondaryIndexSettingsUpdate: Option[Iterable[
      zio.aws.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate
    ]] = None,
    replicaSettingsUpdate: Option[
      Iterable[zio.aws.dynamodb.model.ReplicaSettingsUpdate]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsRequest = {
    import UpdateGlobalTableSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsRequest
      .builder()
      .globalTableName(TableName.unwrap(globalTableName): java.lang.String)
      .optionallyWith(globalTableBillingMode.map(value => value.unwrap))(
        _.globalTableBillingMode
      )
      .optionallyWith(
        globalTableProvisionedWriteCapacityUnits.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.globalTableProvisionedWriteCapacityUnits)
      .optionallyWith(
        globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate.map(
          value => value.buildAwsValue()
        )
      )(_.globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate)
      .optionallyWith(
        globalTableGlobalSecondaryIndexSettingsUpdate.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalTableGlobalSecondaryIndexSettingsUpdate)
      .optionallyWith(
        replicaSettingsUpdate.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicaSettingsUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.UpdateGlobalTableSettingsRequest.ReadOnly =
    zio.aws.dynamodb.model.UpdateGlobalTableSettingsRequest
      .wrap(buildAwsValue())
}
object UpdateGlobalTableSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.UpdateGlobalTableSettingsRequest =
      zio.aws.dynamodb.model.UpdateGlobalTableSettingsRequest(
        globalTableName,
        globalTableBillingMode.map(value => value),
        globalTableProvisionedWriteCapacityUnits.map(value => value),
        globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate.map(
          value => value.asEditable
        ),
        globalTableGlobalSecondaryIndexSettingsUpdate.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        replicaSettingsUpdate.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def globalTableName: TableName
    def globalTableBillingMode: Option[zio.aws.dynamodb.model.BillingMode]
    def globalTableProvisionedWriteCapacityUnits: Option[PositiveLongObject]
    def globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate
        : Option[zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly]
    def globalTableGlobalSecondaryIndexSettingsUpdate: Option[List[
      zio.aws.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate.ReadOnly
    ]]
    def replicaSettingsUpdate
        : Option[List[zio.aws.dynamodb.model.ReplicaSettingsUpdate.ReadOnly]]
    def getGlobalTableName: ZIO[Any, Nothing, TableName] =
      ZIO.succeed(globalTableName)
    def getGlobalTableBillingMode
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.BillingMode] = AwsError
      .unwrapOptionField("globalTableBillingMode", globalTableBillingMode)
    def getGlobalTableProvisionedWriteCapacityUnits
        : ZIO[Any, AwsError, PositiveLongObject] = AwsError.unwrapOptionField(
      "globalTableProvisionedWriteCapacityUnits",
      globalTableProvisionedWriteCapacityUnits
    )
    def getGlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate",
      globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate
    )
    def getGlobalTableGlobalSecondaryIndexSettingsUpdate
        : ZIO[Any, AwsError, List[
          zio.aws.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate.ReadOnly
        ]] = AwsError.unwrapOptionField(
      "globalTableGlobalSecondaryIndexSettingsUpdate",
      globalTableGlobalSecondaryIndexSettingsUpdate
    )
    def getReplicaSettingsUpdate: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ReplicaSettingsUpdate.ReadOnly
    ]] =
      AwsError.unwrapOptionField("replicaSettingsUpdate", replicaSettingsUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsRequest
  ) extends zio.aws.dynamodb.model.UpdateGlobalTableSettingsRequest.ReadOnly {
    override val globalTableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.globalTableName())
    override val globalTableBillingMode
        : Option[zio.aws.dynamodb.model.BillingMode] = scala
      .Option(impl.globalTableBillingMode())
      .map(value => zio.aws.dynamodb.model.BillingMode.wrap(value))
    override val globalTableProvisionedWriteCapacityUnits
        : Option[PositiveLongObject] = scala
      .Option(impl.globalTableProvisionedWriteCapacityUnits())
      .map(value => zio.aws.dynamodb.model.primitives.PositiveLongObject(value))
    override val globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate
        : Option[zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly] =
      scala
        .Option(
          impl.globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate()
        )
        .map(value =>
          zio.aws.dynamodb.model.AutoScalingSettingsUpdate.wrap(value)
        )
    override val globalTableGlobalSecondaryIndexSettingsUpdate: Option[List[
      zio.aws.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate.ReadOnly
    ]] = scala
      .Option(impl.globalTableGlobalSecondaryIndexSettingsUpdate())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate
            .wrap(item)
        }.toList
      )
    override val replicaSettingsUpdate
        : Option[List[zio.aws.dynamodb.model.ReplicaSettingsUpdate.ReadOnly]] =
      scala
        .Option(impl.replicaSettingsUpdate())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.ReplicaSettingsUpdate.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsRequest
  ): zio.aws.dynamodb.model.UpdateGlobalTableSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
