package zio.aws.dynamodb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  PositiveIntegerObject,
  IndexName,
  TableName,
  ProjectionExpression,
  AttributeName,
  ConsistentRead,
  ConditionExpression,
  ExpressionAttributeNameVariable,
  ScanTotalSegments,
  ScanSegment,
  ExpressionAttributeValueVariable
}
import scala.jdk.CollectionConverters._
final case class ScanRequest(
    tableName: TableName,
    indexName: Option[IndexName] = None,
    attributesToGet: Option[Iterable[AttributeName]] = None,
    limit: Option[PositiveIntegerObject] = None,
    select: Option[zio.aws.dynamodb.model.Select] = None,
    scanFilter: Option[Map[AttributeName, zio.aws.dynamodb.model.Condition]] =
      None,
    conditionalOperator: Option[zio.aws.dynamodb.model.ConditionalOperator] =
      None,
    exclusiveStartKey: Option[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]
    ] = None,
    returnConsumedCapacity: Option[
      zio.aws.dynamodb.model.ReturnConsumedCapacity
    ] = None,
    totalSegments: Option[ScanTotalSegments] = None,
    segment: Option[ScanSegment] = None,
    projectionExpression: Option[ProjectionExpression] = None,
    filterExpression: Option[ConditionExpression] = None,
    expressionAttributeNames: Option[
      Map[ExpressionAttributeNameVariable, AttributeName]
    ] = None,
    expressionAttributeValues: Option[Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue
    ]] = None,
    consistentRead: Option[ConsistentRead] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ScanRequest = {
    import ScanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ScanRequest
      .builder()
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(
        attributesToGet.map(value =>
          value.map { item =>
            AttributeName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.attributesToGet)
      .optionallyWith(
        limit.map(value => PositiveIntegerObject.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(select.map(value => value.unwrap))(_.select)
      .optionallyWith(
        scanFilter.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.scanFilter)
      .optionallyWith(conditionalOperator.map(value => value.unwrap))(
        _.conditionalOperator
      )
      .optionallyWith(
        exclusiveStartKey.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.exclusiveStartKey)
      .optionallyWith(returnConsumedCapacity.map(value => value.unwrap))(
        _.returnConsumedCapacity
      )
      .optionallyWith(
        totalSegments.map(value => ScanTotalSegments.unwrap(value): Integer)
      )(_.totalSegments)
      .optionallyWith(segment.map(value => ScanSegment.unwrap(value): Integer))(
        _.segment
      )
      .optionallyWith(
        projectionExpression.map(value =>
          ProjectionExpression.unwrap(value): java.lang.String
        )
      )(_.projectionExpression)
      .optionallyWith(
        filterExpression.map(value =>
          ConditionExpression.unwrap(value): java.lang.String
        )
      )(_.filterExpression)
      .optionallyWith(
        expressionAttributeNames.map(value =>
          value
            .map({ case (key, value) =>
              (ExpressionAttributeNameVariable.unwrap(
                key
              ): java.lang.String) -> (AttributeName.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.expressionAttributeNames)
      .optionallyWith(
        expressionAttributeValues.map(value =>
          value
            .map({ case (key, value) =>
              (ExpressionAttributeValueVariable
                .unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.expressionAttributeValues)
      .optionallyWith(
        consistentRead.map(value =>
          ConsistentRead.unwrap(value): java.lang.Boolean
        )
      )(_.consistentRead)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ScanRequest.ReadOnly =
    zio.aws.dynamodb.model.ScanRequest.wrap(buildAwsValue())
}
object ScanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ScanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ScanRequest =
      zio.aws.dynamodb.model.ScanRequest(
        tableName,
        indexName.map(value => value),
        attributesToGet.map(value => value),
        limit.map(value => value),
        select.map(value => value),
        scanFilter.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        conditionalOperator.map(value => value),
        exclusiveStartKey.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        returnConsumedCapacity.map(value => value),
        totalSegments.map(value => value),
        segment.map(value => value),
        projectionExpression.map(value => value),
        filterExpression.map(value => value),
        expressionAttributeNames.map(value => value),
        expressionAttributeValues.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        consistentRead.map(value => value)
      )
    def tableName: TableName
    def indexName: Option[IndexName]
    def attributesToGet: Option[List[AttributeName]]
    def limit: Option[PositiveIntegerObject]
    def select: Option[zio.aws.dynamodb.model.Select]
    def scanFilter
        : Option[Map[AttributeName, zio.aws.dynamodb.model.Condition.ReadOnly]]
    def conditionalOperator: Option[zio.aws.dynamodb.model.ConditionalOperator]
    def exclusiveStartKey: Option[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ]
    def returnConsumedCapacity
        : Option[zio.aws.dynamodb.model.ReturnConsumedCapacity]
    def totalSegments: Option[ScanTotalSegments]
    def segment: Option[ScanSegment]
    def projectionExpression: Option[ProjectionExpression]
    def filterExpression: Option[ConditionExpression]
    def expressionAttributeNames
        : Option[Map[ExpressionAttributeNameVariable, AttributeName]]
    def expressionAttributeValues: Option[Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]]
    def consistentRead: Option[ConsistentRead]
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getAttributesToGet: ZIO[Any, AwsError, List[AttributeName]] =
      AwsError.unwrapOptionField("attributesToGet", attributesToGet)
    def getLimit: ZIO[Any, AwsError, PositiveIntegerObject] =
      AwsError.unwrapOptionField("limit", limit)
    def getSelect: ZIO[Any, AwsError, zio.aws.dynamodb.model.Select] =
      AwsError.unwrapOptionField("select", select)
    def getScanFilter: ZIO[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodb.model.Condition.ReadOnly
    ]] = AwsError.unwrapOptionField("scanFilter", scanFilter)
    def getConditionalOperator
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ConditionalOperator] =
      AwsError.unwrapOptionField("conditionalOperator", conditionalOperator)
    def getExclusiveStartKey: ZIO[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("exclusiveStartKey", exclusiveStartKey)
    def getReturnConsumedCapacity
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ReturnConsumedCapacity] =
      AwsError.unwrapOptionField(
        "returnConsumedCapacity",
        returnConsumedCapacity
      )
    def getTotalSegments: ZIO[Any, AwsError, ScanTotalSegments] =
      AwsError.unwrapOptionField("totalSegments", totalSegments)
    def getSegment: ZIO[Any, AwsError, ScanSegment] =
      AwsError.unwrapOptionField("segment", segment)
    def getProjectionExpression: ZIO[Any, AwsError, ProjectionExpression] =
      AwsError.unwrapOptionField("projectionExpression", projectionExpression)
    def getFilterExpression: ZIO[Any, AwsError, ConditionExpression] =
      AwsError.unwrapOptionField("filterExpression", filterExpression)
    def getExpressionAttributeNames: ZIO[Any, AwsError, Map[
      ExpressionAttributeNameVariable,
      AttributeName
    ]] = AwsError.unwrapOptionField(
      "expressionAttributeNames",
      expressionAttributeNames
    )
    def getExpressionAttributeValues: ZIO[Any, AwsError, Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "expressionAttributeValues",
      expressionAttributeValues
    )
    def getConsistentRead: ZIO[Any, AwsError, ConsistentRead] =
      AwsError.unwrapOptionField("consistentRead", consistentRead)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ScanRequest
  ) extends zio.aws.dynamodb.model.ScanRequest.ReadOnly {
    override val tableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.tableName())
    override val indexName: Option[IndexName] = scala
      .Option(impl.indexName())
      .map(value => zio.aws.dynamodb.model.primitives.IndexName(value))
    override val attributesToGet: Option[List[AttributeName]] = scala
      .Option(impl.attributesToGet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.primitives.AttributeName(item)
        }.toList
      )
    override val limit: Option[PositiveIntegerObject] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.dynamodb.model.primitives.PositiveIntegerObject(value)
      )
    override val select: Option[zio.aws.dynamodb.model.Select] = scala
      .Option(impl.select())
      .map(value => zio.aws.dynamodb.model.Select.wrap(value))
    override val scanFilter: Option[
      Map[AttributeName, zio.aws.dynamodb.model.Condition.ReadOnly]
    ] = scala
      .Option(impl.scanFilter())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodb.model.Condition.wrap(value)
          })
          .toMap
      )
    override val conditionalOperator
        : Option[zio.aws.dynamodb.model.ConditionalOperator] = scala
      .Option(impl.conditionalOperator())
      .map(value => zio.aws.dynamodb.model.ConditionalOperator.wrap(value))
    override val exclusiveStartKey: Option[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ] = scala
      .Option(impl.exclusiveStartKey())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
          })
          .toMap
      )
    override val returnConsumedCapacity
        : Option[zio.aws.dynamodb.model.ReturnConsumedCapacity] = scala
      .Option(impl.returnConsumedCapacity())
      .map(value => zio.aws.dynamodb.model.ReturnConsumedCapacity.wrap(value))
    override val totalSegments: Option[ScanTotalSegments] = scala
      .Option(impl.totalSegments())
      .map(value => zio.aws.dynamodb.model.primitives.ScanTotalSegments(value))
    override val segment: Option[ScanSegment] = scala
      .Option(impl.segment())
      .map(value => zio.aws.dynamodb.model.primitives.ScanSegment(value))
    override val projectionExpression: Option[ProjectionExpression] = scala
      .Option(impl.projectionExpression())
      .map(value =>
        zio.aws.dynamodb.model.primitives.ProjectionExpression(value)
      )
    override val filterExpression: Option[ConditionExpression] = scala
      .Option(impl.filterExpression())
      .map(value =>
        zio.aws.dynamodb.model.primitives.ConditionExpression(value)
      )
    override val expressionAttributeNames
        : Option[Map[ExpressionAttributeNameVariable, AttributeName]] = scala
      .Option(impl.expressionAttributeNames())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.ExpressionAttributeNameVariable(
              key
            ) -> zio.aws.dynamodb.model.primitives.AttributeName(value)
          })
          .toMap
      )
    override val expressionAttributeValues: Option[Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = scala
      .Option(impl.expressionAttributeValues())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.ExpressionAttributeValueVariable(
              key
            ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
          })
          .toMap
      )
    override val consistentRead: Option[ConsistentRead] = scala
      .Option(impl.consistentRead())
      .map(value => zio.aws.dynamodb.model.primitives.ConsistentRead(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ScanRequest
  ): zio.aws.dynamodb.model.ScanRequest.ReadOnly = new Wrapper(impl)
}
