package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.IndexName
import scala.jdk.CollectionConverters._
final case class ReplicaGlobalSecondaryIndexDescription(
    indexName: Option[IndexName] = None,
    provisionedThroughputOverride: Option[
      zio.aws.dynamodb.model.ProvisionedThroughputOverride
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexDescription = {
    import ReplicaGlobalSecondaryIndexDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexDescription
      .builder()
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(
        provisionedThroughputOverride.map(value => value.buildAwsValue())
      )(_.provisionedThroughputOverride)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexDescription.ReadOnly =
    zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexDescription
      .wrap(buildAwsValue())
}
object ReplicaGlobalSecondaryIndexDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexDescription =
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexDescription(
        indexName.map(value => value),
        provisionedThroughputOverride.map(value => value.asEditable)
      )
    def indexName: Option[IndexName]
    def provisionedThroughputOverride
        : Option[zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly]
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getProvisionedThroughputOverride: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisionedThroughputOverride",
      provisionedThroughputOverride
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexDescription
  ) extends zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexDescription.ReadOnly {
    override val indexName: Option[IndexName] = scala
      .Option(impl.indexName())
      .map(value => zio.aws.dynamodb.model.primitives.IndexName(value))
    override val provisionedThroughputOverride: Option[
      zio.aws.dynamodb.model.ProvisionedThroughputOverride.ReadOnly
    ] = scala
      .Option(impl.provisionedThroughputOverride())
      .map(value =>
        zio.aws.dynamodb.model.ProvisionedThroughputOverride.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexDescription
  ): zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexDescription.ReadOnly =
    new Wrapper(impl)
}
