package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchExecuteStatementResponse(
    responses: Option[Iterable[zio.aws.dynamodb.model.BatchStatementResponse]] =
      None,
    consumedCapacity: Option[
      Iterable[zio.aws.dynamodb.model.ConsumedCapacity]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementResponse = {
    import BatchExecuteStatementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementResponse
      .builder()
      .optionallyWith(
        responses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.responses)
      .optionallyWith(
        consumedCapacity.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.consumedCapacity)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.BatchExecuteStatementResponse.ReadOnly =
    zio.aws.dynamodb.model.BatchExecuteStatementResponse.wrap(buildAwsValue())
}
object BatchExecuteStatementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.BatchExecuteStatementResponse =
      zio.aws.dynamodb.model.BatchExecuteStatementResponse(
        responses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        consumedCapacity.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def responses
        : Option[List[zio.aws.dynamodb.model.BatchStatementResponse.ReadOnly]]
    def consumedCapacity
        : Option[List[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly]]
    def getResponses: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.BatchStatementResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("responses", responses)
    def getConsumedCapacity: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly
    ]] = AwsError.unwrapOptionField("consumedCapacity", consumedCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementResponse
  ) extends zio.aws.dynamodb.model.BatchExecuteStatementResponse.ReadOnly {
    override val responses
        : Option[List[zio.aws.dynamodb.model.BatchStatementResponse.ReadOnly]] =
      scala
        .Option(impl.responses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodb.model.BatchStatementResponse.wrap(item)
          }.toList
        )
    override val consumedCapacity
        : Option[List[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly]] = scala
      .Option(impl.consumedCapacity())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.ConsumedCapacity.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementResponse
  ): zio.aws.dynamodb.model.BatchExecuteStatementResponse.ReadOnly =
    new Wrapper(impl)
}
