package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TransactGetItemsResponse(
    consumedCapacity: Option[
      Iterable[zio.aws.dynamodb.model.ConsumedCapacity]
    ] = None,
    responses: Option[Iterable[zio.aws.dynamodb.model.ItemResponse]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.TransactGetItemsResponse = {
    import TransactGetItemsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.TransactGetItemsResponse
      .builder()
      .optionallyWith(
        consumedCapacity.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.consumedCapacity)
      .optionallyWith(
        responses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.responses)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.TransactGetItemsResponse.ReadOnly =
    zio.aws.dynamodb.model.TransactGetItemsResponse.wrap(buildAwsValue())
}
object TransactGetItemsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.TransactGetItemsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.TransactGetItemsResponse =
      zio.aws.dynamodb.model.TransactGetItemsResponse(
        consumedCapacity.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        responses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def consumedCapacity
        : Option[List[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly]]
    def responses: Option[List[zio.aws.dynamodb.model.ItemResponse.ReadOnly]]
    def getConsumedCapacity: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly
    ]] = AwsError.unwrapOptionField("consumedCapacity", consumedCapacity)
    def getResponses: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ItemResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("responses", responses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.TransactGetItemsResponse
  ) extends zio.aws.dynamodb.model.TransactGetItemsResponse.ReadOnly {
    override val consumedCapacity
        : Option[List[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly]] = scala
      .Option(impl.consumedCapacity())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.ConsumedCapacity.wrap(item)
        }.toList
      )
    override val responses
        : Option[List[zio.aws.dynamodb.model.ItemResponse.ReadOnly]] = scala
      .Option(impl.responses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.ItemResponse.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.TransactGetItemsResponse
  ): zio.aws.dynamodb.model.TransactGetItemsResponse.ReadOnly = new Wrapper(
    impl
  )
}
