package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.ExportNextToken
import scala.jdk.CollectionConverters._
final case class ListExportsResponse(
    exportSummaries: Option[Iterable[zio.aws.dynamodb.model.ExportSummary]] =
      None,
    nextToken: Option[ExportNextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ListExportsResponse = {
    import ListExportsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ListExportsResponse
      .builder()
      .optionallyWith(
        exportSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.exportSummaries)
      .optionallyWith(
        nextToken.map(value => ExportNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ListExportsResponse.ReadOnly =
    zio.aws.dynamodb.model.ListExportsResponse.wrap(buildAwsValue())
}
object ListExportsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ListExportsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ListExportsResponse =
      zio.aws.dynamodb.model.ListExportsResponse(
        exportSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def exportSummaries
        : Option[List[zio.aws.dynamodb.model.ExportSummary.ReadOnly]]
    def nextToken: Option[ExportNextToken]
    def getExportSummaries: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ExportSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("exportSummaries", exportSummaries)
    def getNextToken: ZIO[Any, AwsError, ExportNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ListExportsResponse
  ) extends zio.aws.dynamodb.model.ListExportsResponse.ReadOnly {
    override val exportSummaries
        : Option[List[zio.aws.dynamodb.model.ExportSummary.ReadOnly]] = scala
      .Option(impl.exportSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.ExportSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[ExportNextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.dynamodb.model.primitives.ExportNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ListExportsResponse
  ): zio.aws.dynamodb.model.ListExportsResponse.ReadOnly = new Wrapper(impl)
}
