package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.TableName
import scala.jdk.CollectionConverters._
final case class GlobalTable(
    globalTableName: Option[TableName] = None,
    replicationGroup: Option[Iterable[zio.aws.dynamodb.model.Replica]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.GlobalTable = {
    import GlobalTable.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.GlobalTable
      .builder()
      .optionallyWith(
        globalTableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.globalTableName)
      .optionallyWith(
        replicationGroup.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicationGroup)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.GlobalTable.ReadOnly =
    zio.aws.dynamodb.model.GlobalTable.wrap(buildAwsValue())
}
object GlobalTable {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.GlobalTable
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.GlobalTable =
      zio.aws.dynamodb.model.GlobalTable(
        globalTableName.map(value => value),
        replicationGroup.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def globalTableName: Option[TableName]
    def replicationGroup: Option[List[zio.aws.dynamodb.model.Replica.ReadOnly]]
    def getGlobalTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("globalTableName", globalTableName)
    def getReplicationGroup
        : ZIO[Any, AwsError, List[zio.aws.dynamodb.model.Replica.ReadOnly]] =
      AwsError.unwrapOptionField("replicationGroup", replicationGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.GlobalTable
  ) extends zio.aws.dynamodb.model.GlobalTable.ReadOnly {
    override val globalTableName: Option[TableName] = scala
      .Option(impl.globalTableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val replicationGroup
        : Option[List[zio.aws.dynamodb.model.Replica.ReadOnly]] = scala
      .Option(impl.replicationGroup())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.Replica.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.GlobalTable
  ): zio.aws.dynamodb.model.GlobalTable.ReadOnly = new Wrapper(impl)
}
