package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{Integer, AttributeName}
import scala.jdk.CollectionConverters._
final case class ScanResponse(
    items: Option[
      Iterable[Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]]
    ] = None,
    count: Option[Integer] = None,
    scannedCount: Option[Integer] = None,
    lastEvaluatedKey: Option[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]
    ] = None,
    consumedCapacity: Option[zio.aws.dynamodb.model.ConsumedCapacity] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ScanResponse = {
    import ScanResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ScanResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                (AttributeName.unwrap(key): java.lang.String) -> value
                  .buildAwsValue()
              })
              .asJava
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(count.map(value => value: java.lang.Integer))(_.count)
      .optionallyWith(scannedCount.map(value => value: java.lang.Integer))(
        _.scannedCount
      )
      .optionallyWith(
        lastEvaluatedKey.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.lastEvaluatedKey)
      .optionallyWith(consumedCapacity.map(value => value.buildAwsValue()))(
        _.consumedCapacity
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ScanResponse.ReadOnly =
    zio.aws.dynamodb.model.ScanResponse.wrap(buildAwsValue())
}
object ScanResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ScanResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ScanResponse =
      zio.aws.dynamodb.model.ScanResponse(
        items.map(value =>
          value.map { item =>
            item.map({ case (key, value) =>
              key -> value.asEditable
            })
          }
        ),
        count.map(value => value),
        scannedCount.map(value => value),
        lastEvaluatedKey.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        consumedCapacity.map(value => value.asEditable)
      )
    def items: Option[
      List[Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]]
    ]
    def count: Option[Integer]
    def scannedCount: Option[Integer]
    def lastEvaluatedKey: Option[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ]
    def consumedCapacity
        : Option[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly]
    def getItems: ZIO[Any, AwsError, List[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ]] = AwsError.unwrapOptionField("items", items)
    def getCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("count", count)
    def getScannedCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("scannedCount", scannedCount)
    def getLastEvaluatedKey: ZIO[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("lastEvaluatedKey", lastEvaluatedKey)
    def getConsumedCapacity
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly] =
      AwsError.unwrapOptionField("consumedCapacity", consumedCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ScanResponse
  ) extends zio.aws.dynamodb.model.ScanResponse.ReadOnly {
    override val items: Option[
      List[Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]]
    ] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          item.asScala
            .map({ case (key, value) =>
              zio.aws.dynamodb.model.primitives.AttributeName(
                key
              ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
            })
            .toMap
        }.toList
      )
    override val count: Option[Integer] =
      scala.Option(impl.count()).map(value => value: Integer)
    override val scannedCount: Option[Integer] =
      scala.Option(impl.scannedCount()).map(value => value: Integer)
    override val lastEvaluatedKey: Option[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ] = scala
      .Option(impl.lastEvaluatedKey())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
          })
          .toMap
      )
    override val consumedCapacity
        : Option[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly] = scala
      .Option(impl.consumedCapacity())
      .map(value => zio.aws.dynamodb.model.ConsumedCapacity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ScanResponse
  ): zio.aws.dynamodb.model.ScanResponse.ReadOnly = new Wrapper(impl)
}
