package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReplicaUpdate(
    create: Option[zio.aws.dynamodb.model.CreateReplicaAction] = None,
    delete: Option[zio.aws.dynamodb.model.DeleteReplicaAction] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ReplicaUpdate = {
    import ReplicaUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ReplicaUpdate
      .builder()
      .optionallyWith(create.map(value => value.buildAwsValue()))(_.create)
      .optionallyWith(delete.map(value => value.buildAwsValue()))(_.delete)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ReplicaUpdate.ReadOnly =
    zio.aws.dynamodb.model.ReplicaUpdate.wrap(buildAwsValue())
}
object ReplicaUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ReplicaUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ReplicaUpdate =
      zio.aws.dynamodb.model.ReplicaUpdate(
        create.map(value => value.asEditable),
        delete.map(value => value.asEditable)
      )
    def create: Option[zio.aws.dynamodb.model.CreateReplicaAction.ReadOnly]
    def delete: Option[zio.aws.dynamodb.model.DeleteReplicaAction.ReadOnly]
    def getCreate: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.CreateReplicaAction.ReadOnly
    ] = AwsError.unwrapOptionField("create", create)
    def getDelete: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.DeleteReplicaAction.ReadOnly
    ] = AwsError.unwrapOptionField("delete", delete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaUpdate
  ) extends zio.aws.dynamodb.model.ReplicaUpdate.ReadOnly {
    override val create
        : Option[zio.aws.dynamodb.model.CreateReplicaAction.ReadOnly] = scala
      .Option(impl.create())
      .map(value => zio.aws.dynamodb.model.CreateReplicaAction.wrap(value))
    override val delete
        : Option[zio.aws.dynamodb.model.DeleteReplicaAction.ReadOnly] = scala
      .Option(impl.delete())
      .map(value => zio.aws.dynamodb.model.DeleteReplicaAction.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaUpdate
  ): zio.aws.dynamodb.model.ReplicaUpdate.ReadOnly = new Wrapper(impl)
}
