package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{PositiveLongObject, RegionName}
import scala.jdk.CollectionConverters._
final case class ReplicaSettingsUpdate(
    regionName: RegionName,
    replicaProvisionedReadCapacityUnits: Option[PositiveLongObject] = None,
    replicaProvisionedReadCapacityAutoScalingSettingsUpdate: Option[
      zio.aws.dynamodb.model.AutoScalingSettingsUpdate
    ] = None,
    replicaGlobalSecondaryIndexSettingsUpdate: Option[
      Iterable[zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsUpdate]
    ] = None,
    replicaTableClass: Option[zio.aws.dynamodb.model.TableClass] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ReplicaSettingsUpdate = {
    import ReplicaSettingsUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ReplicaSettingsUpdate
      .builder()
      .regionName(RegionName.unwrap(regionName): java.lang.String)
      .optionallyWith(
        replicaProvisionedReadCapacityUnits.map(value =>
          PositiveLongObject.unwrap(value): java.lang.Long
        )
      )(_.replicaProvisionedReadCapacityUnits)
      .optionallyWith(
        replicaProvisionedReadCapacityAutoScalingSettingsUpdate.map(value =>
          value.buildAwsValue()
        )
      )(_.replicaProvisionedReadCapacityAutoScalingSettingsUpdate)
      .optionallyWith(
        replicaGlobalSecondaryIndexSettingsUpdate.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicaGlobalSecondaryIndexSettingsUpdate)
      .optionallyWith(replicaTableClass.map(value => value.unwrap))(
        _.replicaTableClass
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ReplicaSettingsUpdate.ReadOnly =
    zio.aws.dynamodb.model.ReplicaSettingsUpdate.wrap(buildAwsValue())
}
object ReplicaSettingsUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ReplicaSettingsUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ReplicaSettingsUpdate =
      zio.aws.dynamodb.model.ReplicaSettingsUpdate(
        regionName,
        replicaProvisionedReadCapacityUnits.map(value => value),
        replicaProvisionedReadCapacityAutoScalingSettingsUpdate.map(value =>
          value.asEditable
        ),
        replicaGlobalSecondaryIndexSettingsUpdate.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        replicaTableClass.map(value => value)
      )
    def regionName: RegionName
    def replicaProvisionedReadCapacityUnits: Option[PositiveLongObject]
    def replicaProvisionedReadCapacityAutoScalingSettingsUpdate
        : Option[zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly]
    def replicaGlobalSecondaryIndexSettingsUpdate: Option[List[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsUpdate.ReadOnly
    ]]
    def replicaTableClass: Option[zio.aws.dynamodb.model.TableClass]
    def getRegionName: ZIO[Any, Nothing, RegionName] = ZIO.succeed(regionName)
    def getReplicaProvisionedReadCapacityUnits
        : ZIO[Any, AwsError, PositiveLongObject] = AwsError.unwrapOptionField(
      "replicaProvisionedReadCapacityUnits",
      replicaProvisionedReadCapacityUnits
    )
    def getReplicaProvisionedReadCapacityAutoScalingSettingsUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicaProvisionedReadCapacityAutoScalingSettingsUpdate",
      replicaProvisionedReadCapacityAutoScalingSettingsUpdate
    )
    def getReplicaGlobalSecondaryIndexSettingsUpdate: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "replicaGlobalSecondaryIndexSettingsUpdate",
      replicaGlobalSecondaryIndexSettingsUpdate
    )
    def getReplicaTableClass
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.TableClass] =
      AwsError.unwrapOptionField("replicaTableClass", replicaTableClass)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaSettingsUpdate
  ) extends zio.aws.dynamodb.model.ReplicaSettingsUpdate.ReadOnly {
    override val regionName: RegionName =
      zio.aws.dynamodb.model.primitives.RegionName(impl.regionName())
    override val replicaProvisionedReadCapacityUnits
        : Option[PositiveLongObject] = scala
      .Option(impl.replicaProvisionedReadCapacityUnits())
      .map(value => zio.aws.dynamodb.model.primitives.PositiveLongObject(value))
    override val replicaProvisionedReadCapacityAutoScalingSettingsUpdate
        : Option[zio.aws.dynamodb.model.AutoScalingSettingsUpdate.ReadOnly] =
      scala
        .Option(impl.replicaProvisionedReadCapacityAutoScalingSettingsUpdate())
        .map(value =>
          zio.aws.dynamodb.model.AutoScalingSettingsUpdate.wrap(value)
        )
    override val replicaGlobalSecondaryIndexSettingsUpdate: Option[List[
      zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsUpdate.ReadOnly
    ]] = scala
      .Option(impl.replicaGlobalSecondaryIndexSettingsUpdate())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsUpdate
            .wrap(item)
        }.toList
      )
    override val replicaTableClass: Option[zio.aws.dynamodb.model.TableClass] =
      scala
        .Option(impl.replicaTableClass())
        .map(value => zio.aws.dynamodb.model.TableClass.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicaSettingsUpdate
  ): zio.aws.dynamodb.model.ReplicaSettingsUpdate.ReadOnly = new Wrapper(impl)
}
