package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.AttributeName
import scala.jdk.CollectionConverters._
final case class GetItemResponse(
    item: Option[Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]] =
      None,
    consumedCapacity: Option[zio.aws.dynamodb.model.ConsumedCapacity] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.GetItemResponse = {
    import GetItemResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.GetItemResponse
      .builder()
      .optionallyWith(
        item.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.item)
      .optionallyWith(consumedCapacity.map(value => value.buildAwsValue()))(
        _.consumedCapacity
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.GetItemResponse.ReadOnly =
    zio.aws.dynamodb.model.GetItemResponse.wrap(buildAwsValue())
}
object GetItemResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.GetItemResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.GetItemResponse =
      zio.aws.dynamodb.model.GetItemResponse(
        item.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        consumedCapacity.map(value => value.asEditable)
      )
    def item: Option[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ]
    def consumedCapacity
        : Option[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly]
    def getItem: ZIO[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("item", item)
    def getConsumedCapacity
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly] =
      AwsError.unwrapOptionField("consumedCapacity", consumedCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.GetItemResponse
  ) extends zio.aws.dynamodb.model.GetItemResponse.ReadOnly {
    override val item: Option[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ] = scala
      .Option(impl.item())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
          })
          .toMap
      )
    override val consumedCapacity
        : Option[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly] = scala
      .Option(impl.consumedCapacity())
      .map(value => zio.aws.dynamodb.model.ConsumedCapacity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.GetItemResponse
  ): zio.aws.dynamodb.model.GetItemResponse.ReadOnly = new Wrapper(impl)
}
