package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ExecuteTransactionResponse(
    responses: Option[Iterable[zio.aws.dynamodb.model.ItemResponse]] = None,
    consumedCapacity: Option[
      Iterable[zio.aws.dynamodb.model.ConsumedCapacity]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionResponse = {
    import ExecuteTransactionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionResponse
      .builder()
      .optionallyWith(
        responses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.responses)
      .optionallyWith(
        consumedCapacity.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.consumedCapacity)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ExecuteTransactionResponse.ReadOnly =
    zio.aws.dynamodb.model.ExecuteTransactionResponse.wrap(buildAwsValue())
}
object ExecuteTransactionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ExecuteTransactionResponse =
      zio.aws.dynamodb.model.ExecuteTransactionResponse(
        responses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        consumedCapacity.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def responses: Option[List[zio.aws.dynamodb.model.ItemResponse.ReadOnly]]
    def consumedCapacity
        : Option[List[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly]]
    def getResponses: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ItemResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("responses", responses)
    def getConsumedCapacity: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly
    ]] = AwsError.unwrapOptionField("consumedCapacity", consumedCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionResponse
  ) extends zio.aws.dynamodb.model.ExecuteTransactionResponse.ReadOnly {
    override val responses
        : Option[List[zio.aws.dynamodb.model.ItemResponse.ReadOnly]] = scala
      .Option(impl.responses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.ItemResponse.wrap(item)
        }.toList
      )
    override val consumedCapacity
        : Option[List[zio.aws.dynamodb.model.ConsumedCapacity.ReadOnly]] = scala
      .Option(impl.consumedCapacity())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.ConsumedCapacity.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionResponse
  ): zio.aws.dynamodb.model.ExecuteTransactionResponse.ReadOnly = new Wrapper(
    impl
  )
}
