package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters._
sealed trait ProjectionType {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.ProjectionType
}
object ProjectionType {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.ProjectionType
  ): zio.aws.dynamodb.model.ProjectionType = value match {
    case software.amazon.awssdk.services.dynamodb.model.ProjectionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.ProjectionType.ALL =>
      val r = ALL
      r
    case software.amazon.awssdk.services.dynamodb.model.ProjectionType.KEYS_ONLY =>
      val r = KEYS_ONLY
      r
    case software.amazon.awssdk.services.dynamodb.model.ProjectionType.INCLUDE =>
      val r = INCLUDE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dynamodb.model.ProjectionType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ProjectionType =
      software.amazon.awssdk.services.dynamodb.model.ProjectionType.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL extends zio.aws.dynamodb.model.ProjectionType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ProjectionType =
      software.amazon.awssdk.services.dynamodb.model.ProjectionType.ALL
  }
  case object KEYS_ONLY extends zio.aws.dynamodb.model.ProjectionType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ProjectionType =
      software.amazon.awssdk.services.dynamodb.model.ProjectionType.KEYS_ONLY
  }
  case object INCLUDE extends zio.aws.dynamodb.model.ProjectionType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ProjectionType =
      software.amazon.awssdk.services.dynamodb.model.ProjectionType.INCLUDE
  }
}
