package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.BooleanObject
import scala.jdk.CollectionConverters._
final case class ExpectedAttributeValue(
    value: Option[zio.aws.dynamodb.model.AttributeValue] = None,
    exists: Option[BooleanObject] = None,
    comparisonOperator: Option[zio.aws.dynamodb.model.ComparisonOperator] =
      None,
    attributeValueList: Option[
      Iterable[zio.aws.dynamodb.model.AttributeValue]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue = {
    import ExpectedAttributeValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue
      .builder()
      .optionallyWith(value.map(value => value.buildAwsValue()))(_.value)
      .optionallyWith(exists.map(value => value: java.lang.Boolean))(_.exists)
      .optionallyWith(comparisonOperator.map(value => value.unwrap))(
        _.comparisonOperator
      )
      .optionallyWith(
        attributeValueList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributeValueList)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ExpectedAttributeValue.ReadOnly =
    zio.aws.dynamodb.model.ExpectedAttributeValue.wrap(buildAwsValue())
}
object ExpectedAttributeValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ExpectedAttributeValue =
      zio.aws.dynamodb.model.ExpectedAttributeValue(
        value.map(value => value.asEditable),
        exists.map(value => value),
        comparisonOperator.map(value => value),
        attributeValueList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def value: Option[zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    def exists: Option[BooleanObject]
    def comparisonOperator: Option[zio.aws.dynamodb.model.ComparisonOperator]
    def attributeValueList
        : Option[List[zio.aws.dynamodb.model.AttributeValue.ReadOnly]]
    def getValue
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("value", value)
    def getExists: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("exists", exists)
    def getComparisonOperator
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ComparisonOperator] =
      AwsError.unwrapOptionField("comparisonOperator", comparisonOperator)
    def getAttributeValueList: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("attributeValueList", attributeValueList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue
  ) extends zio.aws.dynamodb.model.ExpectedAttributeValue.ReadOnly {
    override val value: Option[zio.aws.dynamodb.model.AttributeValue.ReadOnly] =
      scala
        .Option(impl.value())
        .map(value => zio.aws.dynamodb.model.AttributeValue.wrap(value))
    override val exists: Option[BooleanObject] =
      scala.Option(impl.exists()).map(value => value: BooleanObject)
    override val comparisonOperator
        : Option[zio.aws.dynamodb.model.ComparisonOperator] = scala
      .Option(impl.comparisonOperator())
      .map(value => zio.aws.dynamodb.model.ComparisonOperator.wrap(value))
    override val attributeValueList
        : Option[List[zio.aws.dynamodb.model.AttributeValue.ReadOnly]] = scala
      .Option(impl.attributeValueList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.AttributeValue.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue
  ): zio.aws.dynamodb.model.ExpectedAttributeValue.ReadOnly = new Wrapper(impl)
}
