package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  LastUpdateDateTime,
  ContributorInsightsRule,
  IndexName,
  TableName
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeContributorInsightsResponse(
    tableName: Option[TableName] = None,
    indexName: Option[IndexName] = None,
    contributorInsightsRuleList: Option[Iterable[ContributorInsightsRule]] =
      None,
    contributorInsightsStatus: Option[
      zio.aws.dynamodb.model.ContributorInsightsStatus
    ] = None,
    lastUpdateDateTime: Option[LastUpdateDateTime] = None,
    failureException: Option[zio.aws.dynamodb.model.FailureException] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsResponse = {
    import DescribeContributorInsightsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsResponse
      .builder()
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(
        contributorInsightsRuleList.map(value =>
          value.map { item =>
            ContributorInsightsRule.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.contributorInsightsRuleList)
      .optionallyWith(contributorInsightsStatus.map(value => value.unwrap))(
        _.contributorInsightsStatus
      )
      .optionallyWith(
        lastUpdateDateTime.map(value =>
          LastUpdateDateTime.unwrap(value): Instant
        )
      )(_.lastUpdateDateTime)
      .optionallyWith(failureException.map(value => value.buildAwsValue()))(
        _.failureException
      )
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.DescribeContributorInsightsResponse.ReadOnly =
    zio.aws.dynamodb.model.DescribeContributorInsightsResponse
      .wrap(buildAwsValue())
}
object DescribeContributorInsightsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DescribeContributorInsightsResponse =
      zio.aws.dynamodb.model.DescribeContributorInsightsResponse(
        tableName.map(value => value),
        indexName.map(value => value),
        contributorInsightsRuleList.map(value => value),
        contributorInsightsStatus.map(value => value),
        lastUpdateDateTime.map(value => value),
        failureException.map(value => value.asEditable)
      )
    def tableName: Option[TableName]
    def indexName: Option[IndexName]
    def contributorInsightsRuleList: Option[List[ContributorInsightsRule]]
    def contributorInsightsStatus
        : Option[zio.aws.dynamodb.model.ContributorInsightsStatus]
    def lastUpdateDateTime: Option[LastUpdateDateTime]
    def failureException
        : Option[zio.aws.dynamodb.model.FailureException.ReadOnly]
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getContributorInsightsRuleList
        : ZIO[Any, AwsError, List[ContributorInsightsRule]] =
      AwsError.unwrapOptionField(
        "contributorInsightsRuleList",
        contributorInsightsRuleList
      )
    def getContributorInsightsStatus
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ContributorInsightsStatus] =
      AwsError.unwrapOptionField(
        "contributorInsightsStatus",
        contributorInsightsStatus
      )
    def getLastUpdateDateTime: ZIO[Any, AwsError, LastUpdateDateTime] =
      AwsError.unwrapOptionField("lastUpdateDateTime", lastUpdateDateTime)
    def getFailureException
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.FailureException.ReadOnly] =
      AwsError.unwrapOptionField("failureException", failureException)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsResponse
  ) extends zio.aws.dynamodb.model.DescribeContributorInsightsResponse.ReadOnly {
    override val tableName: Option[TableName] = scala
      .Option(impl.tableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val indexName: Option[IndexName] = scala
      .Option(impl.indexName())
      .map(value => zio.aws.dynamodb.model.primitives.IndexName(value))
    override val contributorInsightsRuleList
        : Option[List[ContributorInsightsRule]] = scala
      .Option(impl.contributorInsightsRuleList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.primitives.ContributorInsightsRule(item)
        }.toList
      )
    override val contributorInsightsStatus
        : Option[zio.aws.dynamodb.model.ContributorInsightsStatus] = scala
      .Option(impl.contributorInsightsStatus())
      .map(value =>
        zio.aws.dynamodb.model.ContributorInsightsStatus.wrap(value)
      )
    override val lastUpdateDateTime: Option[LastUpdateDateTime] = scala
      .Option(impl.lastUpdateDateTime())
      .map(value => zio.aws.dynamodb.model.primitives.LastUpdateDateTime(value))
    override val failureException
        : Option[zio.aws.dynamodb.model.FailureException.ReadOnly] = scala
      .Option(impl.failureException())
      .map(value => zio.aws.dynamodb.model.FailureException.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsResponse
  ): zio.aws.dynamodb.model.DescribeContributorInsightsResponse.ReadOnly =
    new Wrapper(impl)
}
