package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  TableName,
  AttributeName,
  ConditionExpression,
  ExpressionAttributeNameVariable,
  ExpressionAttributeValueVariable
}
import scala.jdk.CollectionConverters._
final case class ConditionCheck(
    key: Map[AttributeName, zio.aws.dynamodb.model.AttributeValue],
    tableName: TableName,
    conditionExpression: ConditionExpression,
    expressionAttributeNames: Option[
      Map[ExpressionAttributeNameVariable, AttributeName]
    ] = None,
    expressionAttributeValues: Option[Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue
    ]] = None,
    returnValuesOnConditionCheckFailure: Option[
      zio.aws.dynamodb.model.ReturnValuesOnConditionCheckFailure
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ConditionCheck = {
    import ConditionCheck.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ConditionCheck
      .builder()
      .key(
        key
          .map({ case (key, value) =>
            (AttributeName.unwrap(key): java.lang.String) -> value
              .buildAwsValue()
          })
          .asJava
      )
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .conditionExpression(
        ConditionExpression.unwrap(conditionExpression): java.lang.String
      )
      .optionallyWith(
        expressionAttributeNames.map(value =>
          value
            .map({ case (key, value) =>
              (ExpressionAttributeNameVariable.unwrap(
                key
              ): java.lang.String) -> (AttributeName.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.expressionAttributeNames)
      .optionallyWith(
        expressionAttributeValues.map(value =>
          value
            .map({ case (key, value) =>
              (ExpressionAttributeValueVariable
                .unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.expressionAttributeValues)
      .optionallyWith(
        returnValuesOnConditionCheckFailure.map(value => value.unwrap)
      )(_.returnValuesOnConditionCheckFailure)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ConditionCheck.ReadOnly =
    zio.aws.dynamodb.model.ConditionCheck.wrap(buildAwsValue())
}
object ConditionCheck {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ConditionCheck
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ConditionCheck =
      zio.aws.dynamodb.model.ConditionCheck(
        key.map({ case (key, value) =>
          key -> value.asEditable
        }),
        tableName,
        conditionExpression,
        expressionAttributeNames.map(value => value),
        expressionAttributeValues.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        returnValuesOnConditionCheckFailure.map(value => value)
      )
    def key: Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    def tableName: TableName
    def conditionExpression: ConditionExpression
    def expressionAttributeNames
        : Option[Map[ExpressionAttributeNameVariable, AttributeName]]
    def expressionAttributeValues: Option[Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]]
    def returnValuesOnConditionCheckFailure
        : Option[zio.aws.dynamodb.model.ReturnValuesOnConditionCheckFailure]
    def getKey: ZIO[Any, Nothing, Map[
      AttributeName,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = ZIO.succeed(key)
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getConditionExpression: ZIO[Any, Nothing, ConditionExpression] =
      ZIO.succeed(conditionExpression)
    def getExpressionAttributeNames: ZIO[Any, AwsError, Map[
      ExpressionAttributeNameVariable,
      AttributeName
    ]] = AwsError.unwrapOptionField(
      "expressionAttributeNames",
      expressionAttributeNames
    )
    def getExpressionAttributeValues: ZIO[Any, AwsError, Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "expressionAttributeValues",
      expressionAttributeValues
    )
    def getReturnValuesOnConditionCheckFailure: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.ReturnValuesOnConditionCheckFailure
    ] = AwsError.unwrapOptionField(
      "returnValuesOnConditionCheckFailure",
      returnValuesOnConditionCheckFailure
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ConditionCheck
  ) extends zio.aws.dynamodb.model.ConditionCheck.ReadOnly {
    override val key
        : Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly] =
      impl
        .key()
        .asScala
        .map({ case (key, value) =>
          zio.aws.dynamodb.model.primitives.AttributeName(
            key
          ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
        })
        .toMap
    override val tableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.tableName())
    override val conditionExpression: ConditionExpression =
      zio.aws.dynamodb.model.primitives
        .ConditionExpression(impl.conditionExpression())
    override val expressionAttributeNames
        : Option[Map[ExpressionAttributeNameVariable, AttributeName]] = scala
      .Option(impl.expressionAttributeNames())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.ExpressionAttributeNameVariable(
              key
            ) -> zio.aws.dynamodb.model.primitives.AttributeName(value)
          })
          .toMap
      )
    override val expressionAttributeValues: Option[Map[
      ExpressionAttributeValueVariable,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = scala
      .Option(impl.expressionAttributeValues())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.ExpressionAttributeValueVariable(
              key
            ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
          })
          .toMap
      )
    override val returnValuesOnConditionCheckFailure
        : Option[zio.aws.dynamodb.model.ReturnValuesOnConditionCheckFailure] =
      scala
        .Option(impl.returnValuesOnConditionCheckFailure())
        .map(value =>
          zio.aws.dynamodb.model.ReturnValuesOnConditionCheckFailure.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ConditionCheck
  ): zio.aws.dynamodb.model.ConditionCheck.ReadOnly = new Wrapper(impl)
}
