package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ContinuousBackupsDescription(
    continuousBackupsStatus: zio.aws.dynamodb.model.ContinuousBackupsStatus,
    pointInTimeRecoveryDescription: Option[
      zio.aws.dynamodb.model.PointInTimeRecoveryDescription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ContinuousBackupsDescription = {
    import ContinuousBackupsDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ContinuousBackupsDescription
      .builder()
      .continuousBackupsStatus(continuousBackupsStatus.unwrap)
      .optionallyWith(
        pointInTimeRecoveryDescription.map(value => value.buildAwsValue())
      )(_.pointInTimeRecoveryDescription)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ContinuousBackupsDescription.ReadOnly =
    zio.aws.dynamodb.model.ContinuousBackupsDescription.wrap(buildAwsValue())
}
object ContinuousBackupsDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ContinuousBackupsDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ContinuousBackupsDescription =
      zio.aws.dynamodb.model.ContinuousBackupsDescription(
        continuousBackupsStatus,
        pointInTimeRecoveryDescription.map(value => value.asEditable)
      )
    def continuousBackupsStatus: zio.aws.dynamodb.model.ContinuousBackupsStatus
    def pointInTimeRecoveryDescription
        : Option[zio.aws.dynamodb.model.PointInTimeRecoveryDescription.ReadOnly]
    def getContinuousBackupsStatus
        : ZIO[Any, Nothing, zio.aws.dynamodb.model.ContinuousBackupsStatus] =
      ZIO.succeed(continuousBackupsStatus)
    def getPointInTimeRecoveryDescription: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.PointInTimeRecoveryDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pointInTimeRecoveryDescription",
      pointInTimeRecoveryDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ContinuousBackupsDescription
  ) extends zio.aws.dynamodb.model.ContinuousBackupsDescription.ReadOnly {
    override val continuousBackupsStatus
        : zio.aws.dynamodb.model.ContinuousBackupsStatus =
      zio.aws.dynamodb.model.ContinuousBackupsStatus
        .wrap(impl.continuousBackupsStatus())
    override val pointInTimeRecoveryDescription: Option[
      zio.aws.dynamodb.model.PointInTimeRecoveryDescription.ReadOnly
    ] = scala
      .Option(impl.pointInTimeRecoveryDescription())
      .map(value =>
        zio.aws.dynamodb.model.PointInTimeRecoveryDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ContinuousBackupsDescription
  ): zio.aws.dynamodb.model.ContinuousBackupsDescription.ReadOnly = new Wrapper(
    impl
  )
}
