package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.TableName
import scala.jdk.CollectionConverters._
final case class TableAutoScalingDescription(
    tableName: Option[TableName] = None,
    tableStatus: Option[zio.aws.dynamodb.model.TableStatus] = None,
    replicas: Option[
      Iterable[zio.aws.dynamodb.model.ReplicaAutoScalingDescription]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.TableAutoScalingDescription = {
    import TableAutoScalingDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.TableAutoScalingDescription
      .builder()
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(tableStatus.map(value => value.unwrap))(_.tableStatus)
      .optionallyWith(
        replicas.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicas)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.TableAutoScalingDescription.ReadOnly =
    zio.aws.dynamodb.model.TableAutoScalingDescription.wrap(buildAwsValue())
}
object TableAutoScalingDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.TableAutoScalingDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.TableAutoScalingDescription =
      zio.aws.dynamodb.model.TableAutoScalingDescription(
        tableName.map(value => value),
        tableStatus.map(value => value),
        replicas.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tableName: Option[TableName]
    def tableStatus: Option[zio.aws.dynamodb.model.TableStatus]
    def replicas: Option[
      List[zio.aws.dynamodb.model.ReplicaAutoScalingDescription.ReadOnly]
    ]
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getTableStatus: ZIO[Any, AwsError, zio.aws.dynamodb.model.TableStatus] =
      AwsError.unwrapOptionField("tableStatus", tableStatus)
    def getReplicas: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.ReplicaAutoScalingDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("replicas", replicas)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.TableAutoScalingDescription
  ) extends zio.aws.dynamodb.model.TableAutoScalingDescription.ReadOnly {
    override val tableName: Option[TableName] = scala
      .Option(impl.tableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val tableStatus: Option[zio.aws.dynamodb.model.TableStatus] = scala
      .Option(impl.tableStatus())
      .map(value => zio.aws.dynamodb.model.TableStatus.wrap(value))
    override val replicas: Option[
      List[zio.aws.dynamodb.model.ReplicaAutoScalingDescription.ReadOnly]
    ] = scala
      .Option(impl.replicas())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.ReplicaAutoScalingDescription.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.TableAutoScalingDescription
  ): zio.aws.dynamodb.model.TableAutoScalingDescription.ReadOnly = new Wrapper(
    impl
  )
}
