package zio.aws.dynamodb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  RegionName,
  PositiveIntegerObject,
  TableName
}
import scala.jdk.CollectionConverters._
final case class ListGlobalTablesRequest(
    exclusiveStartGlobalTableName: Option[TableName] = None,
    limit: Option[PositiveIntegerObject] = None,
    regionName: Option[RegionName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesRequest = {
    import ListGlobalTablesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesRequest
      .builder()
      .optionallyWith(
        exclusiveStartGlobalTableName.map(value =>
          TableName.unwrap(value): java.lang.String
        )
      )(_.exclusiveStartGlobalTableName)
      .optionallyWith(
        limit.map(value => PositiveIntegerObject.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        regionName.map(value => RegionName.unwrap(value): java.lang.String)
      )(_.regionName)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ListGlobalTablesRequest.ReadOnly =
    zio.aws.dynamodb.model.ListGlobalTablesRequest.wrap(buildAwsValue())
}
object ListGlobalTablesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ListGlobalTablesRequest =
      zio.aws.dynamodb.model.ListGlobalTablesRequest(
        exclusiveStartGlobalTableName.map(value => value),
        limit.map(value => value),
        regionName.map(value => value)
      )
    def exclusiveStartGlobalTableName: Option[TableName]
    def limit: Option[PositiveIntegerObject]
    def regionName: Option[RegionName]
    def getExclusiveStartGlobalTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField(
        "exclusiveStartGlobalTableName",
        exclusiveStartGlobalTableName
      )
    def getLimit: ZIO[Any, AwsError, PositiveIntegerObject] =
      AwsError.unwrapOptionField("limit", limit)
    def getRegionName: ZIO[Any, AwsError, RegionName] =
      AwsError.unwrapOptionField("regionName", regionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesRequest
  ) extends zio.aws.dynamodb.model.ListGlobalTablesRequest.ReadOnly {
    override val exclusiveStartGlobalTableName: Option[TableName] = scala
      .Option(impl.exclusiveStartGlobalTableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val limit: Option[PositiveIntegerObject] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.dynamodb.model.primitives.PositiveIntegerObject(value)
      )
    override val regionName: Option[RegionName] = scala
      .Option(impl.regionName())
      .map(value => zio.aws.dynamodb.model.primitives.RegionName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesRequest
  ): zio.aws.dynamodb.model.ListGlobalTablesRequest.ReadOnly = new Wrapper(impl)
}
