package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeGlobalTableResponse(
    globalTableDescription: Option[
      zio.aws.dynamodb.model.GlobalTableDescription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableResponse = {
    import DescribeGlobalTableResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableResponse
      .builder()
      .optionallyWith(
        globalTableDescription.map(value => value.buildAwsValue())
      )(_.globalTableDescription)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.DescribeGlobalTableResponse.ReadOnly =
    zio.aws.dynamodb.model.DescribeGlobalTableResponse.wrap(buildAwsValue())
}
object DescribeGlobalTableResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DescribeGlobalTableResponse =
      zio.aws.dynamodb.model.DescribeGlobalTableResponse(
        globalTableDescription.map(value => value.asEditable)
      )
    def globalTableDescription
        : Option[zio.aws.dynamodb.model.GlobalTableDescription.ReadOnly]
    def getGlobalTableDescription: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.GlobalTableDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "globalTableDescription",
      globalTableDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableResponse
  ) extends zio.aws.dynamodb.model.DescribeGlobalTableResponse.ReadOnly {
    override val globalTableDescription
        : Option[zio.aws.dynamodb.model.GlobalTableDescription.ReadOnly] = scala
      .Option(impl.globalTableDescription())
      .map(value => zio.aws.dynamodb.model.GlobalTableDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableResponse
  ): zio.aws.dynamodb.model.DescribeGlobalTableResponse.ReadOnly = new Wrapper(
    impl
  )
}
