package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters._
sealed trait BatchStatementErrorCodeEnum {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum
}
object BatchStatementErrorCodeEnum {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum
  ): zio.aws.dynamodb.model.BatchStatementErrorCodeEnum = value match {
    case software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum.CONDITIONAL_CHECK_FAILED =>
      val r = ConditionalCheckFailed
      r
    case software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum.ITEM_COLLECTION_SIZE_LIMIT_EXCEEDED =>
      val r = ItemCollectionSizeLimitExceeded
      r
    case software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum.REQUEST_LIMIT_EXCEEDED =>
      val r = RequestLimitExceeded
      r
    case software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum.VALIDATION_ERROR =>
      val r = ValidationError
      r
    case software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum.PROVISIONED_THROUGHPUT_EXCEEDED =>
      val r = ProvisionedThroughputExceeded
      r
    case software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum.TRANSACTION_CONFLICT =>
      val r = TransactionConflict
      r
    case software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum.THROTTLING_ERROR =>
      val r = ThrottlingError
      r
    case software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum.INTERNAL_SERVER_ERROR =>
      val r = InternalServerError
      r
    case software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum.RESOURCE_NOT_FOUND =>
      val r = ResourceNotFound
      r
    case software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum.ACCESS_DENIED =>
      val r = AccessDenied
      r
    case software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum.DUPLICATE_ITEM =>
      val r = DuplicateItem
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dynamodb.model.BatchStatementErrorCodeEnum {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum =
      software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object ConditionalCheckFailed
      extends zio.aws.dynamodb.model.BatchStatementErrorCodeEnum {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum =
      software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum.CONDITIONAL_CHECK_FAILED
  }
  case object ItemCollectionSizeLimitExceeded
      extends zio.aws.dynamodb.model.BatchStatementErrorCodeEnum {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum =
      software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum.ITEM_COLLECTION_SIZE_LIMIT_EXCEEDED
  }
  case object RequestLimitExceeded
      extends zio.aws.dynamodb.model.BatchStatementErrorCodeEnum {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum =
      software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum.REQUEST_LIMIT_EXCEEDED
  }
  case object ValidationError
      extends zio.aws.dynamodb.model.BatchStatementErrorCodeEnum {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum =
      software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum.VALIDATION_ERROR
  }
  case object ProvisionedThroughputExceeded
      extends zio.aws.dynamodb.model.BatchStatementErrorCodeEnum {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum =
      software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum.PROVISIONED_THROUGHPUT_EXCEEDED
  }
  case object TransactionConflict
      extends zio.aws.dynamodb.model.BatchStatementErrorCodeEnum {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum =
      software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum.TRANSACTION_CONFLICT
  }
  case object ThrottlingError
      extends zio.aws.dynamodb.model.BatchStatementErrorCodeEnum {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum =
      software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum.THROTTLING_ERROR
  }
  case object InternalServerError
      extends zio.aws.dynamodb.model.BatchStatementErrorCodeEnum {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum =
      software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum.INTERNAL_SERVER_ERROR
  }
  case object ResourceNotFound
      extends zio.aws.dynamodb.model.BatchStatementErrorCodeEnum {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum =
      software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum.RESOURCE_NOT_FOUND
  }
  case object AccessDenied
      extends zio.aws.dynamodb.model.BatchStatementErrorCodeEnum {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum =
      software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum.ACCESS_DENIED
  }
  case object DuplicateItem
      extends zio.aws.dynamodb.model.BatchStatementErrorCodeEnum {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum =
      software.amazon.awssdk.services.dynamodb.model.BatchStatementErrorCodeEnum.DUPLICATE_ITEM
  }
}
