package zio.aws.dynamodb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  ListContributorInsightsLimit,
  NextTokenString,
  TableName
}
import scala.jdk.CollectionConverters._
final case class ListContributorInsightsRequest(
    tableName: Option[TableName] = None,
    nextToken: Option[NextTokenString] = None,
    maxResults: Option[ListContributorInsightsLimit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest = {
    import ListContributorInsightsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest
      .builder()
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        nextToken.map(value => NextTokenString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          ListContributorInsightsLimit.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.ListContributorInsightsRequest.ReadOnly =
    zio.aws.dynamodb.model.ListContributorInsightsRequest.wrap(buildAwsValue())
}
object ListContributorInsightsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ListContributorInsightsRequest =
      zio.aws.dynamodb.model.ListContributorInsightsRequest(
        tableName.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def tableName: Option[TableName]
    def nextToken: Option[NextTokenString]
    def maxResults: Option[ListContributorInsightsLimit]
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getNextToken: ZIO[Any, AwsError, NextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListContributorInsightsLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest
  ) extends zio.aws.dynamodb.model.ListContributorInsightsRequest.ReadOnly {
    override val tableName: Option[TableName] = scala
      .Option(impl.tableName())
      .map(value => zio.aws.dynamodb.model.primitives.TableName(value))
    override val nextToken: Option[NextTokenString] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.dynamodb.model.primitives.NextTokenString(value))
    override val maxResults: Option[ListContributorInsightsLimit] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.dynamodb.model.primitives.ListContributorInsightsLimit(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest
  ): zio.aws.dynamodb.model.ListContributorInsightsRequest.ReadOnly =
    new Wrapper(impl)
}
