package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.ClientRequestToken
import scala.jdk.CollectionConverters._
final case class ExecuteTransactionRequest(
    transactStatements: Iterable[zio.aws.dynamodb.model.ParameterizedStatement],
    clientRequestToken: Option[ClientRequestToken] = None,
    returnConsumedCapacity: Option[
      zio.aws.dynamodb.model.ReturnConsumedCapacity
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionRequest = {
    import ExecuteTransactionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionRequest
      .builder()
      .transactStatements(transactStatements.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(returnConsumedCapacity.map(value => value.unwrap))(
        _.returnConsumedCapacity
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ExecuteTransactionRequest.ReadOnly =
    zio.aws.dynamodb.model.ExecuteTransactionRequest.wrap(buildAwsValue())
}
object ExecuteTransactionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ExecuteTransactionRequest =
      zio.aws.dynamodb.model.ExecuteTransactionRequest(
        transactStatements.map { item =>
          item.asEditable
        },
        clientRequestToken.map(value => value),
        returnConsumedCapacity.map(value => value)
      )
    def transactStatements
        : List[zio.aws.dynamodb.model.ParameterizedStatement.ReadOnly]
    def clientRequestToken: Option[ClientRequestToken]
    def returnConsumedCapacity
        : Option[zio.aws.dynamodb.model.ReturnConsumedCapacity]
    def getTransactStatements: ZIO[Any, Nothing, List[
      zio.aws.dynamodb.model.ParameterizedStatement.ReadOnly
    ]] = ZIO.succeed(transactStatements)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getReturnConsumedCapacity
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ReturnConsumedCapacity] =
      AwsError.unwrapOptionField(
        "returnConsumedCapacity",
        returnConsumedCapacity
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionRequest
  ) extends zio.aws.dynamodb.model.ExecuteTransactionRequest.ReadOnly {
    override val transactStatements
        : List[zio.aws.dynamodb.model.ParameterizedStatement.ReadOnly] = impl
      .transactStatements()
      .asScala
      .map { item =>
        zio.aws.dynamodb.model.ParameterizedStatement.wrap(item)
      }
      .toList
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value => zio.aws.dynamodb.model.primitives.ClientRequestToken(value))
    override val returnConsumedCapacity
        : Option[zio.aws.dynamodb.model.ReturnConsumedCapacity] = scala
      .Option(impl.returnConsumedCapacity())
      .map(value => zio.aws.dynamodb.model.ReturnConsumedCapacity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionRequest
  ): zio.aws.dynamodb.model.ExecuteTransactionRequest.ReadOnly = new Wrapper(
    impl
  )
}
