package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.Date
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class PointInTimeRecoveryDescription(
    pointInTimeRecoveryStatus: Option[
      zio.aws.dynamodb.model.PointInTimeRecoveryStatus
    ] = None,
    earliestRestorableDateTime: Option[Date] = None,
    latestRestorableDateTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryDescription = {
    import PointInTimeRecoveryDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryDescription
      .builder()
      .optionallyWith(pointInTimeRecoveryStatus.map(value => value.unwrap))(
        _.pointInTimeRecoveryStatus
      )
      .optionallyWith(
        earliestRestorableDateTime.map(value => Date.unwrap(value): Instant)
      )(_.earliestRestorableDateTime)
      .optionallyWith(
        latestRestorableDateTime.map(value => Date.unwrap(value): Instant)
      )(_.latestRestorableDateTime)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.PointInTimeRecoveryDescription.ReadOnly =
    zio.aws.dynamodb.model.PointInTimeRecoveryDescription.wrap(buildAwsValue())
}
object PointInTimeRecoveryDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.PointInTimeRecoveryDescription =
      zio.aws.dynamodb.model.PointInTimeRecoveryDescription(
        pointInTimeRecoveryStatus.map(value => value),
        earliestRestorableDateTime.map(value => value),
        latestRestorableDateTime.map(value => value)
      )
    def pointInTimeRecoveryStatus
        : Option[zio.aws.dynamodb.model.PointInTimeRecoveryStatus]
    def earliestRestorableDateTime: Option[Date]
    def latestRestorableDateTime: Option[Date]
    def getPointInTimeRecoveryStatus
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.PointInTimeRecoveryStatus] =
      AwsError.unwrapOptionField(
        "pointInTimeRecoveryStatus",
        pointInTimeRecoveryStatus
      )
    def getEarliestRestorableDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField(
        "earliestRestorableDateTime",
        earliestRestorableDateTime
      )
    def getLatestRestorableDateTime: ZIO[Any, AwsError, Date] = AwsError
      .unwrapOptionField("latestRestorableDateTime", latestRestorableDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryDescription
  ) extends zio.aws.dynamodb.model.PointInTimeRecoveryDescription.ReadOnly {
    override val pointInTimeRecoveryStatus
        : Option[zio.aws.dynamodb.model.PointInTimeRecoveryStatus] = scala
      .Option(impl.pointInTimeRecoveryStatus())
      .map(value =>
        zio.aws.dynamodb.model.PointInTimeRecoveryStatus.wrap(value)
      )
    override val earliestRestorableDateTime: Option[Date] = scala
      .Option(impl.earliestRestorableDateTime())
      .map(value => zio.aws.dynamodb.model.primitives.Date(value))
    override val latestRestorableDateTime: Option[Date] = scala
      .Option(impl.latestRestorableDateTime())
      .map(value => zio.aws.dynamodb.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryDescription
  ): zio.aws.dynamodb.model.PointInTimeRecoveryDescription.ReadOnly =
    new Wrapper(impl)
}
