package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SourceTableFeatureDetails(
    localSecondaryIndexes: Option[
      Iterable[zio.aws.dynamodb.model.LocalSecondaryIndexInfo]
    ] = None,
    globalSecondaryIndexes: Option[
      Iterable[zio.aws.dynamodb.model.GlobalSecondaryIndexInfo]
    ] = None,
    streamDescription: Option[zio.aws.dynamodb.model.StreamSpecification] =
      None,
    timeToLiveDescription: Option[
      zio.aws.dynamodb.model.TimeToLiveDescription
    ] = None,
    sseDescription: Option[zio.aws.dynamodb.model.SSEDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.SourceTableFeatureDetails = {
    import SourceTableFeatureDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.SourceTableFeatureDetails
      .builder()
      .optionallyWith(
        localSecondaryIndexes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.localSecondaryIndexes)
      .optionallyWith(
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalSecondaryIndexes)
      .optionallyWith(streamDescription.map(value => value.buildAwsValue()))(
        _.streamDescription
      )
      .optionallyWith(
        timeToLiveDescription.map(value => value.buildAwsValue())
      )(_.timeToLiveDescription)
      .optionallyWith(sseDescription.map(value => value.buildAwsValue()))(
        _.sseDescription
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.SourceTableFeatureDetails.ReadOnly =
    zio.aws.dynamodb.model.SourceTableFeatureDetails.wrap(buildAwsValue())
}
object SourceTableFeatureDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.SourceTableFeatureDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.SourceTableFeatureDetails =
      zio.aws.dynamodb.model.SourceTableFeatureDetails(
        localSecondaryIndexes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        globalSecondaryIndexes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        streamDescription.map(value => value.asEditable),
        timeToLiveDescription.map(value => value.asEditable),
        sseDescription.map(value => value.asEditable)
      )
    def localSecondaryIndexes
        : Option[List[zio.aws.dynamodb.model.LocalSecondaryIndexInfo.ReadOnly]]
    def globalSecondaryIndexes
        : Option[List[zio.aws.dynamodb.model.GlobalSecondaryIndexInfo.ReadOnly]]
    def streamDescription
        : Option[zio.aws.dynamodb.model.StreamSpecification.ReadOnly]
    def timeToLiveDescription
        : Option[zio.aws.dynamodb.model.TimeToLiveDescription.ReadOnly]
    def sseDescription: Option[zio.aws.dynamodb.model.SSEDescription.ReadOnly]
    def getLocalSecondaryIndexes: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.LocalSecondaryIndexInfo.ReadOnly
    ]] =
      AwsError.unwrapOptionField("localSecondaryIndexes", localSecondaryIndexes)
    def getGlobalSecondaryIndexes: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.GlobalSecondaryIndexInfo.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "globalSecondaryIndexes",
      globalSecondaryIndexes
    )
    def getStreamDescription: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.StreamSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("streamDescription", streamDescription)
    def getTimeToLiveDescription: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.TimeToLiveDescription.ReadOnly
    ] =
      AwsError.unwrapOptionField("timeToLiveDescription", timeToLiveDescription)
    def getSseDescription
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.SSEDescription.ReadOnly] =
      AwsError.unwrapOptionField("sseDescription", sseDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.SourceTableFeatureDetails
  ) extends zio.aws.dynamodb.model.SourceTableFeatureDetails.ReadOnly {
    override val localSecondaryIndexes: Option[
      List[zio.aws.dynamodb.model.LocalSecondaryIndexInfo.ReadOnly]
    ] = scala
      .Option(impl.localSecondaryIndexes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.LocalSecondaryIndexInfo.wrap(item)
        }.toList
      )
    override val globalSecondaryIndexes: Option[
      List[zio.aws.dynamodb.model.GlobalSecondaryIndexInfo.ReadOnly]
    ] = scala
      .Option(impl.globalSecondaryIndexes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.GlobalSecondaryIndexInfo.wrap(item)
        }.toList
      )
    override val streamDescription
        : Option[zio.aws.dynamodb.model.StreamSpecification.ReadOnly] = scala
      .Option(impl.streamDescription())
      .map(value => zio.aws.dynamodb.model.StreamSpecification.wrap(value))
    override val timeToLiveDescription
        : Option[zio.aws.dynamodb.model.TimeToLiveDescription.ReadOnly] = scala
      .Option(impl.timeToLiveDescription())
      .map(value => zio.aws.dynamodb.model.TimeToLiveDescription.wrap(value))
    override val sseDescription
        : Option[zio.aws.dynamodb.model.SSEDescription.ReadOnly] = scala
      .Option(impl.sseDescription())
      .map(value => zio.aws.dynamodb.model.SSEDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.SourceTableFeatureDetails
  ): zio.aws.dynamodb.model.SourceTableFeatureDetails.ReadOnly = new Wrapper(
    impl
  )
}
