package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  RestoreInProgress,
  Date,
  TableArn,
  BackupArn
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class RestoreSummary(
    sourceBackupArn: Option[BackupArn] = None,
    sourceTableArn: Option[TableArn] = None,
    restoreDateTime: Date,
    restoreInProgress: RestoreInProgress
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.RestoreSummary = {
    import RestoreSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.RestoreSummary
      .builder()
      .optionallyWith(
        sourceBackupArn.map(value => BackupArn.unwrap(value): java.lang.String)
      )(_.sourceBackupArn)
      .optionallyWith(
        sourceTableArn.map(value => TableArn.unwrap(value): java.lang.String)
      )(_.sourceTableArn)
      .restoreDateTime(Date.unwrap(restoreDateTime): Instant)
      .restoreInProgress(
        RestoreInProgress.unwrap(restoreInProgress): java.lang.Boolean
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.RestoreSummary.ReadOnly =
    zio.aws.dynamodb.model.RestoreSummary.wrap(buildAwsValue())
}
object RestoreSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.RestoreSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.RestoreSummary =
      zio.aws.dynamodb.model.RestoreSummary(
        sourceBackupArn.map(value => value),
        sourceTableArn.map(value => value),
        restoreDateTime,
        restoreInProgress
      )
    def sourceBackupArn: Option[BackupArn]
    def sourceTableArn: Option[TableArn]
    def restoreDateTime: Date
    def restoreInProgress: RestoreInProgress
    def getSourceBackupArn: ZIO[Any, AwsError, BackupArn] =
      AwsError.unwrapOptionField("sourceBackupArn", sourceBackupArn)
    def getSourceTableArn: ZIO[Any, AwsError, TableArn] =
      AwsError.unwrapOptionField("sourceTableArn", sourceTableArn)
    def getRestoreDateTime: ZIO[Any, Nothing, Date] =
      ZIO.succeed(restoreDateTime)
    def getRestoreInProgress: ZIO[Any, Nothing, RestoreInProgress] =
      ZIO.succeed(restoreInProgress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.RestoreSummary
  ) extends zio.aws.dynamodb.model.RestoreSummary.ReadOnly {
    override val sourceBackupArn: Option[BackupArn] = scala
      .Option(impl.sourceBackupArn())
      .map(value => zio.aws.dynamodb.model.primitives.BackupArn(value))
    override val sourceTableArn: Option[TableArn] = scala
      .Option(impl.sourceTableArn())
      .map(value => zio.aws.dynamodb.model.primitives.TableArn(value))
    override val restoreDateTime: Date =
      zio.aws.dynamodb.model.primitives.Date(impl.restoreDateTime())
    override val restoreInProgress: RestoreInProgress =
      zio.aws.dynamodb.model.primitives
        .RestoreInProgress(impl.restoreInProgress())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.RestoreSummary
  ): zio.aws.dynamodb.model.RestoreSummary.ReadOnly = new Wrapper(impl)
}
