package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReplicationGroupUpdate(
    create: Option[zio.aws.dynamodb.model.CreateReplicationGroupMemberAction] =
      None,
    update: Option[zio.aws.dynamodb.model.UpdateReplicationGroupMemberAction] =
      None,
    delete: Option[zio.aws.dynamodb.model.DeleteReplicationGroupMemberAction] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ReplicationGroupUpdate = {
    import ReplicationGroupUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ReplicationGroupUpdate
      .builder()
      .optionallyWith(create.map(value => value.buildAwsValue()))(_.create)
      .optionallyWith(update.map(value => value.buildAwsValue()))(_.update)
      .optionallyWith(delete.map(value => value.buildAwsValue()))(_.delete)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.ReplicationGroupUpdate.ReadOnly =
    zio.aws.dynamodb.model.ReplicationGroupUpdate.wrap(buildAwsValue())
}
object ReplicationGroupUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ReplicationGroupUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ReplicationGroupUpdate =
      zio.aws.dynamodb.model.ReplicationGroupUpdate(
        create.map(value => value.asEditable),
        update.map(value => value.asEditable),
        delete.map(value => value.asEditable)
      )
    def create: Option[
      zio.aws.dynamodb.model.CreateReplicationGroupMemberAction.ReadOnly
    ]
    def update: Option[
      zio.aws.dynamodb.model.UpdateReplicationGroupMemberAction.ReadOnly
    ]
    def delete: Option[
      zio.aws.dynamodb.model.DeleteReplicationGroupMemberAction.ReadOnly
    ]
    def getCreate: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.CreateReplicationGroupMemberAction.ReadOnly
    ] = AwsError.unwrapOptionField("create", create)
    def getUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.UpdateReplicationGroupMemberAction.ReadOnly
    ] = AwsError.unwrapOptionField("update", update)
    def getDelete: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.DeleteReplicationGroupMemberAction.ReadOnly
    ] = AwsError.unwrapOptionField("delete", delete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicationGroupUpdate
  ) extends zio.aws.dynamodb.model.ReplicationGroupUpdate.ReadOnly {
    override val create: Option[
      zio.aws.dynamodb.model.CreateReplicationGroupMemberAction.ReadOnly
    ] = scala
      .Option(impl.create())
      .map(value =>
        zio.aws.dynamodb.model.CreateReplicationGroupMemberAction.wrap(value)
      )
    override val update: Option[
      zio.aws.dynamodb.model.UpdateReplicationGroupMemberAction.ReadOnly
    ] = scala
      .Option(impl.update())
      .map(value =>
        zio.aws.dynamodb.model.UpdateReplicationGroupMemberAction.wrap(value)
      )
    override val delete: Option[
      zio.aws.dynamodb.model.DeleteReplicationGroupMemberAction.ReadOnly
    ] = scala
      .Option(impl.delete())
      .map(value =>
        zio.aws.dynamodb.model.DeleteReplicationGroupMemberAction.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ReplicationGroupUpdate
  ): zio.aws.dynamodb.model.ReplicationGroupUpdate.ReadOnly = new Wrapper(impl)
}
