package zio.aws.dynamodb
import zio.aws.dynamodb.model.primitives.TimeRangeLowerBound.Type
import java.time.Instant
import zio.aws.dynamodb.model.primitives.{
  IndexName,
  TableName,
  AttributeName,
  ItemCollectionSizeEstimateBound,
  ContributorInsightsRule,
  ExpressionAttributeNameVariable,
  StringAttributeValue,
  NumberAttributeValue,
  NonKeyAttributeName,
  ExpressionAttributeValueVariable,
  TagKeyString,
  BinaryAttributeValue
}
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ArchivalReason extends Subtype[String]
    type ArchivalReason = zio.aws.dynamodb.model.primitives.ArchivalReason.Type
    object AttributeName extends Subtype[String]
    type AttributeName = zio.aws.dynamodb.model.primitives.AttributeName.Type
    object AutoScalingPolicyName extends Subtype[String]
    type AutoScalingPolicyName =
      zio.aws.dynamodb.model.primitives.AutoScalingPolicyName.Type
    object AutoScalingRoleArn extends Subtype[String]
    type AutoScalingRoleArn =
      zio.aws.dynamodb.model.primitives.AutoScalingRoleArn.Type
    object Backfilling extends Subtype[Boolean]
    type Backfilling = zio.aws.dynamodb.model.primitives.Backfilling.Type
    object BackupArn extends Subtype[String]
    type BackupArn = zio.aws.dynamodb.model.primitives.BackupArn.Type
    object BackupCreationDateTime extends Subtype[Instant]
    type BackupCreationDateTime =
      zio.aws.dynamodb.model.primitives.BackupCreationDateTime.Type
    object BackupName extends Subtype[String]
    type BackupName = zio.aws.dynamodb.model.primitives.BackupName.Type
    object BackupSizeBytes extends Subtype[Long]
    type BackupSizeBytes =
      zio.aws.dynamodb.model.primitives.BackupSizeBytes.Type
    object BackupsInputLimit extends Subtype[Int]
    type BackupsInputLimit =
      zio.aws.dynamodb.model.primitives.BackupsInputLimit.Type
    object BilledSizeBytes extends Subtype[Long]
    type BilledSizeBytes =
      zio.aws.dynamodb.model.primitives.BilledSizeBytes.Type
    object BinaryAttributeValue extends Subtype[Chunk[Byte]]
    type BinaryAttributeValue =
      zio.aws.dynamodb.model.primitives.BinaryAttributeValue.Type
    object BooleanAttributeValue extends Subtype[Boolean]
    type BooleanAttributeValue =
      zio.aws.dynamodb.model.primitives.BooleanAttributeValue.Type
    object BooleanObject extends Subtype[Boolean]
    type BooleanObject = zio.aws.dynamodb.model.primitives.BooleanObject.Type
    object ClientRequestToken extends Subtype[String]
    type ClientRequestToken =
      zio.aws.dynamodb.model.primitives.ClientRequestToken.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.dynamodb.model.primitives.ClientToken.Type
    object ConditionExpression extends Subtype[String]
    type ConditionExpression =
      zio.aws.dynamodb.model.primitives.ConditionExpression.Type
    object ConsistentRead extends Subtype[Boolean]
    type ConsistentRead = zio.aws.dynamodb.model.primitives.ConsistentRead.Type
    object ConsumedCapacityUnits extends Subtype[Double]
    type ConsumedCapacityUnits =
      zio.aws.dynamodb.model.primitives.ConsumedCapacityUnits.Type
    object ContributorInsightsRule extends Subtype[String]
    type ContributorInsightsRule =
      zio.aws.dynamodb.model.primitives.ContributorInsightsRule.Type
    object Date extends Subtype[Instant]
    type Date = zio.aws.dynamodb.model.primitives.Date.Type
    object ExceptionDescription extends Subtype[String]
    type ExceptionDescription =
      zio.aws.dynamodb.model.primitives.ExceptionDescription.Type
    object ExceptionName extends Subtype[String]
    type ExceptionName = zio.aws.dynamodb.model.primitives.ExceptionName.Type
    object ExportArn extends Subtype[String]
    type ExportArn = zio.aws.dynamodb.model.primitives.ExportArn.Type
    object ExportEndTime extends Subtype[Instant]
    type ExportEndTime = zio.aws.dynamodb.model.primitives.ExportEndTime.Type
    object ExportManifest extends Subtype[String]
    type ExportManifest = zio.aws.dynamodb.model.primitives.ExportManifest.Type
    object ExportNextToken extends Subtype[String]
    type ExportNextToken =
      zio.aws.dynamodb.model.primitives.ExportNextToken.Type
    object ExportStartTime extends Subtype[Instant]
    type ExportStartTime =
      zio.aws.dynamodb.model.primitives.ExportStartTime.Type
    object ExportTime extends Subtype[Instant]
    type ExportTime = zio.aws.dynamodb.model.primitives.ExportTime.Type
    object ExpressionAttributeNameVariable extends Subtype[String]
    type ExpressionAttributeNameVariable =
      zio.aws.dynamodb.model.primitives.ExpressionAttributeNameVariable.Type
    object ExpressionAttributeValueVariable extends Subtype[String]
    type ExpressionAttributeValueVariable =
      zio.aws.dynamodb.model.primitives.ExpressionAttributeValueVariable.Type
    object FailureCode extends Subtype[String]
    type FailureCode = zio.aws.dynamodb.model.primitives.FailureCode.Type
    object FailureMessage extends Subtype[String]
    type FailureMessage = zio.aws.dynamodb.model.primitives.FailureMessage.Type
    object GlobalTableArnString extends Subtype[String]
    type GlobalTableArnString =
      zio.aws.dynamodb.model.primitives.GlobalTableArnString.Type
    object IndexName extends Subtype[String]
    type IndexName = zio.aws.dynamodb.model.primitives.IndexName.Type
    object Integer extends Subtype[Int]
    type Integer = zio.aws.dynamodb.model.primitives.Integer.Type
    object IntegerObject extends Subtype[Int]
    type IntegerObject = zio.aws.dynamodb.model.primitives.IntegerObject.Type
    object ItemCollectionSizeEstimateBound extends Subtype[Double]
    type ItemCollectionSizeEstimateBound =
      zio.aws.dynamodb.model.primitives.ItemCollectionSizeEstimateBound.Type
    object ItemCount extends Subtype[Long]
    type ItemCount = zio.aws.dynamodb.model.primitives.ItemCount.Type
    object KMSMasterKeyArn extends Subtype[String]
    type KMSMasterKeyArn =
      zio.aws.dynamodb.model.primitives.KMSMasterKeyArn.Type
    object KMSMasterKeyId extends Subtype[String]
    type KMSMasterKeyId = zio.aws.dynamodb.model.primitives.KMSMasterKeyId.Type
    object KeyExpression extends Subtype[String]
    type KeyExpression = zio.aws.dynamodb.model.primitives.KeyExpression.Type
    object KeySchemaAttributeName extends Subtype[String]
    type KeySchemaAttributeName =
      zio.aws.dynamodb.model.primitives.KeySchemaAttributeName.Type
    object LastUpdateDateTime extends Subtype[Instant]
    type LastUpdateDateTime =
      zio.aws.dynamodb.model.primitives.LastUpdateDateTime.Type
    object ListContributorInsightsLimit extends Subtype[Int]
    type ListContributorInsightsLimit =
      zio.aws.dynamodb.model.primitives.ListContributorInsightsLimit.Type
    object ListExportsMaxLimit extends Subtype[Int]
    type ListExportsMaxLimit =
      zio.aws.dynamodb.model.primitives.ListExportsMaxLimit.Type
    object ListTablesInputLimit extends Subtype[Int]
    type ListTablesInputLimit =
      zio.aws.dynamodb.model.primitives.ListTablesInputLimit.Type
    object NextTokenString extends Subtype[String]
    type NextTokenString =
      zio.aws.dynamodb.model.primitives.NextTokenString.Type
    object NonKeyAttributeName extends Subtype[String]
    type NonKeyAttributeName =
      zio.aws.dynamodb.model.primitives.NonKeyAttributeName.Type
    object NonNegativeLongObject extends Subtype[Long]
    type NonNegativeLongObject =
      zio.aws.dynamodb.model.primitives.NonNegativeLongObject.Type
    object NullAttributeValue extends Subtype[Boolean]
    type NullAttributeValue =
      zio.aws.dynamodb.model.primitives.NullAttributeValue.Type
    object NumberAttributeValue extends Subtype[String]
    type NumberAttributeValue =
      zio.aws.dynamodb.model.primitives.NumberAttributeValue.Type
    object PartiQLNextToken extends Subtype[String]
    type PartiQLNextToken =
      zio.aws.dynamodb.model.primitives.PartiQLNextToken.Type
    object PartiQLStatement extends Subtype[String]
    type PartiQLStatement =
      zio.aws.dynamodb.model.primitives.PartiQLStatement.Type
    object PositiveIntegerObject extends Subtype[Int]
    type PositiveIntegerObject =
      zio.aws.dynamodb.model.primitives.PositiveIntegerObject.Type
    object PositiveLongObject extends Subtype[Long]
    type PositiveLongObject =
      zio.aws.dynamodb.model.primitives.PositiveLongObject.Type
    object ProjectionExpression extends Subtype[String]
    type ProjectionExpression =
      zio.aws.dynamodb.model.primitives.ProjectionExpression.Type
    object RegionName extends Subtype[String]
    type RegionName = zio.aws.dynamodb.model.primitives.RegionName.Type
    object ReplicaStatusDescription extends Subtype[String]
    type ReplicaStatusDescription =
      zio.aws.dynamodb.model.primitives.ReplicaStatusDescription.Type
    object ReplicaStatusPercentProgress extends Subtype[String]
    type ReplicaStatusPercentProgress =
      zio.aws.dynamodb.model.primitives.ReplicaStatusPercentProgress.Type
    object ResourceArnString extends Subtype[String]
    type ResourceArnString =
      zio.aws.dynamodb.model.primitives.ResourceArnString.Type
    object RestoreInProgress extends Subtype[Boolean]
    type RestoreInProgress =
      zio.aws.dynamodb.model.primitives.RestoreInProgress.Type
    object S3Bucket extends Subtype[String]
    type S3Bucket = zio.aws.dynamodb.model.primitives.S3Bucket.Type
    object S3BucketOwner extends Subtype[String]
    type S3BucketOwner = zio.aws.dynamodb.model.primitives.S3BucketOwner.Type
    object S3Prefix extends Subtype[String]
    type S3Prefix = zio.aws.dynamodb.model.primitives.S3Prefix.Type
    object S3SseKmsKeyId extends Subtype[String]
    type S3SseKmsKeyId = zio.aws.dynamodb.model.primitives.S3SseKmsKeyId.Type
    object SSEEnabled extends Subtype[Boolean]
    type SSEEnabled = zio.aws.dynamodb.model.primitives.SSEEnabled.Type
    object ScanSegment extends Subtype[Int]
    type ScanSegment = zio.aws.dynamodb.model.primitives.ScanSegment.Type
    object ScanTotalSegments extends Subtype[Int]
    type ScanTotalSegments =
      zio.aws.dynamodb.model.primitives.ScanTotalSegments.Type
    object StreamArn extends Subtype[String]
    type StreamArn = zio.aws.dynamodb.model.primitives.StreamArn.Type
    object StreamEnabled extends Subtype[Boolean]
    type StreamEnabled = zio.aws.dynamodb.model.primitives.StreamEnabled.Type
    object StringAttributeValue extends Subtype[String]
    type StringAttributeValue =
      zio.aws.dynamodb.model.primitives.StringAttributeValue.Type
    object TableArn extends Subtype[String]
    type TableArn = zio.aws.dynamodb.model.primitives.TableArn.Type
    object TableCreationDateTime extends Subtype[Instant]
    type TableCreationDateTime =
      zio.aws.dynamodb.model.primitives.TableCreationDateTime.Type
    object TableId extends Subtype[String]
    type TableId = zio.aws.dynamodb.model.primitives.TableId.Type
    object TableName extends Subtype[String]
    type TableName = zio.aws.dynamodb.model.primitives.TableName.Type
    object TagKeyString extends Subtype[String]
    type TagKeyString = zio.aws.dynamodb.model.primitives.TagKeyString.Type
    object TagValueString extends Subtype[String]
    type TagValueString = zio.aws.dynamodb.model.primitives.TagValueString.Type
    object TimeRangeLowerBound extends Subtype[Instant]
    type TimeRangeLowerBound =
      zio.aws.dynamodb.model.primitives.TimeRangeLowerBound.Type
    object TimeRangeUpperBound extends Subtype[Instant]
    type TimeRangeUpperBound =
      zio.aws.dynamodb.model.primitives.TimeRangeUpperBound.Type
    object TimeToLiveAttributeName extends Subtype[String]
    type TimeToLiveAttributeName =
      zio.aws.dynamodb.model.primitives.TimeToLiveAttributeName.Type
    object TimeToLiveEnabled extends Subtype[Boolean]
    type TimeToLiveEnabled =
      zio.aws.dynamodb.model.primitives.TimeToLiveEnabled.Type
    object UpdateExpression extends Subtype[String]
    type UpdateExpression =
      zio.aws.dynamodb.model.primitives.UpdateExpression.Type
  }
  type AttributeDefinitions = List[zio.aws.dynamodb.model.AttributeDefinition]
  type AttributeMap = Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]
  type AttributeNameList = List[AttributeName]
  type AttributeUpdates =
    Map[AttributeName, zio.aws.dynamodb.model.AttributeValueUpdate]
  type AttributeValueList = List[zio.aws.dynamodb.model.AttributeValue]
  type AutoScalingPolicyDescriptionList =
    List[zio.aws.dynamodb.model.AutoScalingPolicyDescription]
  type BackupSummaries = List[zio.aws.dynamodb.model.BackupSummary]
  type BatchGetRequestMap =
    Map[TableName, zio.aws.dynamodb.model.KeysAndAttributes]
  type BatchGetResponseMap = Map[TableName, Iterable[
    Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]
  ]]
  type BatchWriteItemRequestMap =
    Map[TableName, Iterable[zio.aws.dynamodb.model.WriteRequest]]
  type BinarySetAttributeValue = List[BinaryAttributeValue]
  type ConsumedCapacityMultiple = List[zio.aws.dynamodb.model.ConsumedCapacity]
  type ContributorInsightsRuleList = List[ContributorInsightsRule]
  type ContributorInsightsSummaries =
    List[zio.aws.dynamodb.model.ContributorInsightsSummary]
  type Endpoints = List[zio.aws.dynamodb.model.Endpoint]
  type ExpectedAttributeMap =
    Map[AttributeName, zio.aws.dynamodb.model.ExpectedAttributeValue]
  type ExportSummaries = List[zio.aws.dynamodb.model.ExportSummary]
  type ExpressionAttributeNameMap =
    Map[ExpressionAttributeNameVariable, AttributeName]
  type ExpressionAttributeValueMap =
    Map[ExpressionAttributeValueVariable, zio.aws.dynamodb.model.AttributeValue]
  type FilterConditionMap = Map[AttributeName, zio.aws.dynamodb.model.Condition]
  type GlobalSecondaryIndexAutoScalingUpdateList =
    List[zio.aws.dynamodb.model.GlobalSecondaryIndexAutoScalingUpdate]
  type GlobalSecondaryIndexDescriptionList =
    List[zio.aws.dynamodb.model.GlobalSecondaryIndexDescription]
  type GlobalSecondaryIndexList =
    List[zio.aws.dynamodb.model.GlobalSecondaryIndex]
  type GlobalSecondaryIndexUpdateList =
    List[zio.aws.dynamodb.model.GlobalSecondaryIndexUpdate]
  type GlobalSecondaryIndexes =
    List[zio.aws.dynamodb.model.GlobalSecondaryIndexInfo]
  type GlobalTableGlobalSecondaryIndexSettingsUpdateList =
    List[zio.aws.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate]
  type GlobalTableList = List[zio.aws.dynamodb.model.GlobalTable]
  type ItemCollectionKeyAttributeMap =
    Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]
  type ItemCollectionMetricsMultiple =
    List[zio.aws.dynamodb.model.ItemCollectionMetrics]
  type ItemCollectionMetricsPerTable =
    Map[TableName, Iterable[zio.aws.dynamodb.model.ItemCollectionMetrics]]
  type ItemCollectionSizeEstimateRange = List[ItemCollectionSizeEstimateBound]
  type ItemList =
    List[Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]]
  type ItemResponseList = List[zio.aws.dynamodb.model.ItemResponse]
  type Key = Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]
  type KeyConditions = Map[AttributeName, zio.aws.dynamodb.model.Condition]
  type KeyList = List[Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]]
  type KeySchema = List[zio.aws.dynamodb.model.KeySchemaElement]
  type KinesisDataStreamDestinations =
    List[zio.aws.dynamodb.model.KinesisDataStreamDestination]
  type ListAttributeValue = List[zio.aws.dynamodb.model.AttributeValue]
  type LocalSecondaryIndexDescriptionList =
    List[zio.aws.dynamodb.model.LocalSecondaryIndexDescription]
  type LocalSecondaryIndexList =
    List[zio.aws.dynamodb.model.LocalSecondaryIndex]
  type LocalSecondaryIndexes =
    List[zio.aws.dynamodb.model.LocalSecondaryIndexInfo]
  type MapAttributeValue =
    Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]
  type NonKeyAttributeNameList = List[NonKeyAttributeName]
  type NumberSetAttributeValue = List[NumberAttributeValue]
  type ParameterizedStatements =
    List[zio.aws.dynamodb.model.ParameterizedStatement]
  type PartiQLBatchRequest = List[zio.aws.dynamodb.model.BatchStatementRequest]
  type PartiQLBatchResponse =
    List[zio.aws.dynamodb.model.BatchStatementResponse]
  type PreparedStatementParameters = List[zio.aws.dynamodb.model.AttributeValue]
  type PutItemInputAttributeMap =
    Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]
  type ReplicaAutoScalingDescriptionList =
    List[zio.aws.dynamodb.model.ReplicaAutoScalingDescription]
  type ReplicaAutoScalingUpdateList =
    List[zio.aws.dynamodb.model.ReplicaAutoScalingUpdate]
  type ReplicaDescriptionList = List[zio.aws.dynamodb.model.ReplicaDescription]
  type ReplicaGlobalSecondaryIndexAutoScalingDescriptionList = List[
    zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingDescription
  ]
  type ReplicaGlobalSecondaryIndexAutoScalingUpdateList =
    List[zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate]
  type ReplicaGlobalSecondaryIndexDescriptionList =
    List[zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexDescription]
  type ReplicaGlobalSecondaryIndexList =
    List[zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndex]
  type ReplicaGlobalSecondaryIndexSettingsDescriptionList =
    List[zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsDescription]
  type ReplicaGlobalSecondaryIndexSettingsUpdateList =
    List[zio.aws.dynamodb.model.ReplicaGlobalSecondaryIndexSettingsUpdate]
  type ReplicaList = List[zio.aws.dynamodb.model.Replica]
  type ReplicaSettingsDescriptionList =
    List[zio.aws.dynamodb.model.ReplicaSettingsDescription]
  type ReplicaSettingsUpdateList =
    List[zio.aws.dynamodb.model.ReplicaSettingsUpdate]
  type ReplicaUpdateList = List[zio.aws.dynamodb.model.ReplicaUpdate]
  type ReplicationGroupUpdateList =
    List[zio.aws.dynamodb.model.ReplicationGroupUpdate]
  type SecondaryIndexesCapacityMap =
    Map[IndexName, zio.aws.dynamodb.model.Capacity]
  type StringSetAttributeValue = List[StringAttributeValue]
  type TableNameList = List[TableName]
  type TagKeyList = List[TagKeyString]
  type TagList = List[zio.aws.dynamodb.model.Tag]
  type TransactGetItemList = List[zio.aws.dynamodb.model.TransactGetItem]
  type TransactWriteItemList = List[zio.aws.dynamodb.model.TransactWriteItem]
  type WriteRequests = List[zio.aws.dynamodb.model.WriteRequest]
}
