package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  AttributeName,
  StringAttributeValue,
  NumberAttributeValue,
  NullAttributeValue,
  BooleanAttributeValue,
  BinaryAttributeValue
}
import scala.jdk.CollectionConverters._
final case class AttributeValue(
    s: Option[StringAttributeValue] = None,
    n: Option[NumberAttributeValue] = None,
    b: Option[BinaryAttributeValue] = None,
    ss: Option[Iterable[StringAttributeValue]] = None,
    ns: Option[Iterable[NumberAttributeValue]] = None,
    bs: Option[Iterable[BinaryAttributeValue]] = None,
    m: Option[Map[AttributeName, zio.aws.dynamodb.model.AttributeValue]] = None,
    l: Option[Iterable[zio.aws.dynamodb.model.AttributeValue]] = None,
    nul: Option[NullAttributeValue] = None,
    bool: Option[BooleanAttributeValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.AttributeValue = {
    import AttributeValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.AttributeValue
      .builder()
      .optionallyWith(
        s.map(value => StringAttributeValue.unwrap(value): java.lang.String)
      )(_.s)
      .optionallyWith(
        n.map(value => NumberAttributeValue.unwrap(value): java.lang.String)
      )(_.n)
      .optionallyWith(
        b.map(value =>
          software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
            value.toArray[Byte]
          )
        )
      )(_.b)
      .optionallyWith(
        ss.map(value =>
          value.map { item =>
            StringAttributeValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ss)
      .optionallyWith(
        ns.map(value =>
          value.map { item =>
            NumberAttributeValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ns)
      .optionallyWith(
        bs.map(value =>
          value.map { item =>
            software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
              item.toArray[Byte]
            )
          }.asJavaCollection
        )
      )(_.bs)
      .optionallyWith(
        m.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.m)
      .optionallyWith(
        l.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.l)
      .optionallyWith(
        nul.map(value => NullAttributeValue.unwrap(value): java.lang.Boolean)
      )(_.nul)
      .optionallyWith(
        bool.map(value =>
          BooleanAttributeValue.unwrap(value): java.lang.Boolean
        )
      )(_.bool)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.AttributeValue.ReadOnly =
    zio.aws.dynamodb.model.AttributeValue.wrap(buildAwsValue())
}
object AttributeValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.AttributeValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.AttributeValue =
      zio.aws.dynamodb.model.AttributeValue(
        s.map(value => value),
        n.map(value => value),
        b.map(value => value),
        ss.map(value => value),
        ns.map(value => value),
        bs.map(value => value),
        m.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        l.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nul.map(value => value),
        bool.map(value => value)
      )
    def s: Option[StringAttributeValue]
    def n: Option[NumberAttributeValue]
    def b: Option[BinaryAttributeValue]
    def ss: Option[List[StringAttributeValue]]
    def ns: Option[List[NumberAttributeValue]]
    def bs: Option[List[BinaryAttributeValue]]
    def m: Option[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ]
    def l: Option[List[zio.aws.dynamodb.model.AttributeValue.ReadOnly]]
    def nul: Option[NullAttributeValue]
    def bool: Option[BooleanAttributeValue]
    def getS: ZIO[Any, AwsError, StringAttributeValue] =
      AwsError.unwrapOptionField("s", s)
    def getN: ZIO[Any, AwsError, NumberAttributeValue] =
      AwsError.unwrapOptionField("n", n)
    def getB: ZIO[Any, AwsError, BinaryAttributeValue] =
      AwsError.unwrapOptionField("b", b)
    def getSs: ZIO[Any, AwsError, List[StringAttributeValue]] =
      AwsError.unwrapOptionField("ss", ss)
    def getNs: ZIO[Any, AwsError, List[NumberAttributeValue]] =
      AwsError.unwrapOptionField("ns", ns)
    def getBs: ZIO[Any, AwsError, List[BinaryAttributeValue]] =
      AwsError.unwrapOptionField("bs", bs)
    def getM: ZIO[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("m", m)
    def getL: ZIO[Any, AwsError, List[
      zio.aws.dynamodb.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("l", l)
    def getNul: ZIO[Any, AwsError, NullAttributeValue] =
      AwsError.unwrapOptionField("nul", nul)
    def getBool: ZIO[Any, AwsError, BooleanAttributeValue] =
      AwsError.unwrapOptionField("bool", bool)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.AttributeValue
  ) extends zio.aws.dynamodb.model.AttributeValue.ReadOnly {
    override val s: Option[StringAttributeValue] = scala
      .Option(impl.s())
      .map(value =>
        zio.aws.dynamodb.model.primitives.StringAttributeValue(value)
      )
    override val n: Option[NumberAttributeValue] = scala
      .Option(impl.n())
      .map(value =>
        zio.aws.dynamodb.model.primitives.NumberAttributeValue(value)
      )
    override val b: Option[BinaryAttributeValue] = scala
      .Option(impl.b())
      .map(value =>
        zio.aws.dynamodb.model.primitives
          .BinaryAttributeValue(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val ss: Option[List[StringAttributeValue]] = scala
      .Option(impl.ss())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.primitives.StringAttributeValue(item)
        }.toList
      )
    override val ns: Option[List[NumberAttributeValue]] = scala
      .Option(impl.ns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.primitives.NumberAttributeValue(item)
        }.toList
      )
    override val bs: Option[List[BinaryAttributeValue]] = scala
      .Option(impl.bs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.primitives
            .BinaryAttributeValue(zio.Chunk.fromArray(item.asByteArrayUnsafe()))
        }.toList
      )
    override val m: Option[
      Map[AttributeName, zio.aws.dynamodb.model.AttributeValue.ReadOnly]
    ] = scala
      .Option(impl.m())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodb.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodb.model.AttributeValue.wrap(value)
          })
          .toMap
      )
    override val l
        : Option[List[zio.aws.dynamodb.model.AttributeValue.ReadOnly]] = scala
      .Option(impl.l())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodb.model.AttributeValue.wrap(item)
        }.toList
      )
    override val nul: Option[NullAttributeValue] = scala
      .Option(impl.nul())
      .map(value => zio.aws.dynamodb.model.primitives.NullAttributeValue(value))
    override val bool: Option[BooleanAttributeValue] = scala
      .Option(impl.bool())
      .map(value =>
        zio.aws.dynamodb.model.primitives.BooleanAttributeValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.AttributeValue
  ): zio.aws.dynamodb.model.AttributeValue.ReadOnly = new Wrapper(impl)
}
