package zio.aws.dynamodb.model
import scala.jdk.CollectionConverters._
sealed trait Select {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.Select
}
object Select {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.Select
  ): zio.aws.dynamodb.model.Select = value match {
    case software.amazon.awssdk.services.dynamodb.model.Select.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.Select.ALL_ATTRIBUTES =>
      val r = ALL_ATTRIBUTES
      r
    case software.amazon.awssdk.services.dynamodb.model.Select.ALL_PROJECTED_ATTRIBUTES =>
      val r = ALL_PROJECTED_ATTRIBUTES
      r
    case software.amazon.awssdk.services.dynamodb.model.Select.SPECIFIC_ATTRIBUTES =>
      val r = SPECIFIC_ATTRIBUTES
      r
    case software.amazon.awssdk.services.dynamodb.model.Select.COUNT =>
      val r = COUNT
      r
  }
  case object unknownToSdkVersion extends zio.aws.dynamodb.model.Select {
    override def unwrap: software.amazon.awssdk.services.dynamodb.model.Select =
      software.amazon.awssdk.services.dynamodb.model.Select.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL_ATTRIBUTES extends zio.aws.dynamodb.model.Select {
    override def unwrap: software.amazon.awssdk.services.dynamodb.model.Select =
      software.amazon.awssdk.services.dynamodb.model.Select.ALL_ATTRIBUTES
  }
  case object ALL_PROJECTED_ATTRIBUTES extends zio.aws.dynamodb.model.Select {
    override def unwrap: software.amazon.awssdk.services.dynamodb.model.Select =
      software.amazon.awssdk.services.dynamodb.model.Select.ALL_PROJECTED_ATTRIBUTES
  }
  case object SPECIFIC_ATTRIBUTES extends zio.aws.dynamodb.model.Select {
    override def unwrap: software.amazon.awssdk.services.dynamodb.model.Select =
      software.amazon.awssdk.services.dynamodb.model.Select.SPECIFIC_ATTRIBUTES
  }
  case object COUNT extends zio.aws.dynamodb.model.Select {
    override def unwrap: software.amazon.awssdk.services.dynamodb.model.Select =
      software.amazon.awssdk.services.dynamodb.model.Select.COUNT
  }
}
