package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dynamodb.model.primitives.{
  ExportTime,
  S3Prefix,
  S3BucketOwner,
  S3SseKmsKeyId,
  TableArn,
  ClientToken,
  S3Bucket
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ExportTableToPointInTimeRequest(
    tableArn: TableArn,
    exportTime: Option[ExportTime] = None,
    clientToken: Option[ClientToken] = None,
    s3Bucket: S3Bucket,
    s3BucketOwner: Option[S3BucketOwner] = None,
    s3Prefix: Option[S3Prefix] = None,
    s3SseAlgorithm: Option[zio.aws.dynamodb.model.S3SseAlgorithm] = None,
    s3SseKmsKeyId: Option[S3SseKmsKeyId] = None,
    exportFormat: Option[zio.aws.dynamodb.model.ExportFormat] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeRequest = {
    import ExportTableToPointInTimeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeRequest
      .builder()
      .tableArn(TableArn.unwrap(tableArn): java.lang.String)
      .optionallyWith(
        exportTime.map(value => ExportTime.unwrap(value): Instant)
      )(_.exportTime)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .s3Bucket(S3Bucket.unwrap(s3Bucket): java.lang.String)
      .optionallyWith(
        s3BucketOwner.map(value =>
          S3BucketOwner.unwrap(value): java.lang.String
        )
      )(_.s3BucketOwner)
      .optionallyWith(
        s3Prefix.map(value => S3Prefix.unwrap(value): java.lang.String)
      )(_.s3Prefix)
      .optionallyWith(s3SseAlgorithm.map(value => value.unwrap))(
        _.s3SseAlgorithm
      )
      .optionallyWith(
        s3SseKmsKeyId.map(value =>
          S3SseKmsKeyId.unwrap(value): java.lang.String
        )
      )(_.s3SseKmsKeyId)
      .optionallyWith(exportFormat.map(value => value.unwrap))(_.exportFormat)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.ExportTableToPointInTimeRequest.ReadOnly =
    zio.aws.dynamodb.model.ExportTableToPointInTimeRequest.wrap(buildAwsValue())
}
object ExportTableToPointInTimeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.ExportTableToPointInTimeRequest =
      zio.aws.dynamodb.model.ExportTableToPointInTimeRequest(
        tableArn,
        exportTime.map(value => value),
        clientToken.map(value => value),
        s3Bucket,
        s3BucketOwner.map(value => value),
        s3Prefix.map(value => value),
        s3SseAlgorithm.map(value => value),
        s3SseKmsKeyId.map(value => value),
        exportFormat.map(value => value)
      )
    def tableArn: TableArn
    def exportTime: Option[ExportTime]
    def clientToken: Option[ClientToken]
    def s3Bucket: S3Bucket
    def s3BucketOwner: Option[S3BucketOwner]
    def s3Prefix: Option[S3Prefix]
    def s3SseAlgorithm: Option[zio.aws.dynamodb.model.S3SseAlgorithm]
    def s3SseKmsKeyId: Option[S3SseKmsKeyId]
    def exportFormat: Option[zio.aws.dynamodb.model.ExportFormat]
    def getTableArn: ZIO[Any, Nothing, TableArn] = ZIO.succeed(tableArn)
    def getExportTime: ZIO[Any, AwsError, ExportTime] =
      AwsError.unwrapOptionField("exportTime", exportTime)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getS3Bucket: ZIO[Any, Nothing, S3Bucket] = ZIO.succeed(s3Bucket)
    def getS3BucketOwner: ZIO[Any, AwsError, S3BucketOwner] =
      AwsError.unwrapOptionField("s3BucketOwner", s3BucketOwner)
    def getS3Prefix: ZIO[Any, AwsError, S3Prefix] =
      AwsError.unwrapOptionField("s3Prefix", s3Prefix)
    def getS3SseAlgorithm
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.S3SseAlgorithm] =
      AwsError.unwrapOptionField("s3SseAlgorithm", s3SseAlgorithm)
    def getS3SseKmsKeyId: ZIO[Any, AwsError, S3SseKmsKeyId] =
      AwsError.unwrapOptionField("s3SseKmsKeyId", s3SseKmsKeyId)
    def getExportFormat
        : ZIO[Any, AwsError, zio.aws.dynamodb.model.ExportFormat] =
      AwsError.unwrapOptionField("exportFormat", exportFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeRequest
  ) extends zio.aws.dynamodb.model.ExportTableToPointInTimeRequest.ReadOnly {
    override val tableArn: TableArn =
      zio.aws.dynamodb.model.primitives.TableArn(impl.tableArn())
    override val exportTime: Option[ExportTime] = scala
      .Option(impl.exportTime())
      .map(value => zio.aws.dynamodb.model.primitives.ExportTime(value))
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.dynamodb.model.primitives.ClientToken(value))
    override val s3Bucket: S3Bucket =
      zio.aws.dynamodb.model.primitives.S3Bucket(impl.s3Bucket())
    override val s3BucketOwner: Option[S3BucketOwner] = scala
      .Option(impl.s3BucketOwner())
      .map(value => zio.aws.dynamodb.model.primitives.S3BucketOwner(value))
    override val s3Prefix: Option[S3Prefix] = scala
      .Option(impl.s3Prefix())
      .map(value => zio.aws.dynamodb.model.primitives.S3Prefix(value))
    override val s3SseAlgorithm: Option[zio.aws.dynamodb.model.S3SseAlgorithm] =
      scala
        .Option(impl.s3SseAlgorithm())
        .map(value => zio.aws.dynamodb.model.S3SseAlgorithm.wrap(value))
    override val s3SseKmsKeyId: Option[S3SseKmsKeyId] = scala
      .Option(impl.s3SseKmsKeyId())
      .map(value => zio.aws.dynamodb.model.primitives.S3SseKmsKeyId(value))
    override val exportFormat: Option[zio.aws.dynamodb.model.ExportFormat] =
      scala
        .Option(impl.exportFormat())
        .map(value => zio.aws.dynamodb.model.ExportFormat.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeRequest
  ): zio.aws.dynamodb.model.ExportTableToPointInTimeRequest.ReadOnly =
    new Wrapper(impl)
}
