package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeTimeToLiveResponse(
    timeToLiveDescription: Option[
      zio.aws.dynamodb.model.TimeToLiveDescription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveResponse = {
    import DescribeTimeToLiveResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveResponse
      .builder()
      .optionallyWith(
        timeToLiveDescription.map(value => value.buildAwsValue())
      )(_.timeToLiveDescription)
      .build()
  }
  def asReadOnly: zio.aws.dynamodb.model.DescribeTimeToLiveResponse.ReadOnly =
    zio.aws.dynamodb.model.DescribeTimeToLiveResponse.wrap(buildAwsValue())
}
object DescribeTimeToLiveResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DescribeTimeToLiveResponse =
      zio.aws.dynamodb.model.DescribeTimeToLiveResponse(
        timeToLiveDescription.map(value => value.asEditable)
      )
    def timeToLiveDescription
        : Option[zio.aws.dynamodb.model.TimeToLiveDescription.ReadOnly]
    def getTimeToLiveDescription: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodb.model.TimeToLiveDescription.ReadOnly
    ] =
      AwsError.unwrapOptionField("timeToLiveDescription", timeToLiveDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveResponse
  ) extends zio.aws.dynamodb.model.DescribeTimeToLiveResponse.ReadOnly {
    override val timeToLiveDescription
        : Option[zio.aws.dynamodb.model.TimeToLiveDescription.ReadOnly] = scala
      .Option(impl.timeToLiveDescription())
      .map(value => zio.aws.dynamodb.model.TimeToLiveDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveResponse
  ): zio.aws.dynamodb.model.DescribeTimeToLiveResponse.ReadOnly = new Wrapper(
    impl
  )
}
