package zio.aws.dynamodb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.dynamodb.model.primitives.TableName
import scala.jdk.CollectionConverters._
final case class DescribeGlobalTableSettingsRequest(
    globalTableName: TableName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableSettingsRequest = {
    import DescribeGlobalTableSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableSettingsRequest
      .builder()
      .globalTableName(TableName.unwrap(globalTableName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodb.model.DescribeGlobalTableSettingsRequest.ReadOnly =
    zio.aws.dynamodb.model.DescribeGlobalTableSettingsRequest
      .wrap(buildAwsValue())
}
object DescribeGlobalTableSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodb.model.DescribeGlobalTableSettingsRequest =
      zio.aws.dynamodb.model.DescribeGlobalTableSettingsRequest(globalTableName)
    def globalTableName: TableName
    def getGlobalTableName: ZIO[Any, Nothing, TableName] =
      ZIO.succeed(globalTableName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableSettingsRequest
  ) extends zio.aws.dynamodb.model.DescribeGlobalTableSettingsRequest.ReadOnly {
    override val globalTableName: TableName =
      zio.aws.dynamodb.model.primitives.TableName(impl.globalTableName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableSettingsRequest
  ): zio.aws.dynamodb.model.DescribeGlobalTableSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
